﻿// Chinese translation by yuyuko#4941

const Name = '简体中文';

function GetString(str, tokens) {
    switch (str) {
        // connection-manager
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-1': return `[连接错误]: 无法连接到服务器${tokens.address}:${tokens.port} (${tokens.code})! 通常导致这个问题的原因:`;
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-2': return '[连接错误]: 网络连接不稳定，或者IP被地区封锁.';
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-3': return '[连接错误]: 游戏服务器正在维护.';
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-1': return `[连接错误]: ${tokens.code}-与服务器突然断开连接. 通常导致这个问题的原因:`;
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-2': return '[连接错误]: 由于网络不稳定导致的网络连接中断';
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-3': return '[连接错误]: 由于使用了作弊/修改/损坏的插件脚本，或修改过的模型文件，导致被服务器踢出.';
        case 'connection-manager/connected': return `[连接错误] 关联 ${tokens.remote} 至${tokens.remoteAddress}:${tokens.remotePort}`;
        case 'connection-manager/disconnected': return `[连接错误] ${tokens.remote} 失去连接`;

        // loader-cli
        case 'loader-cli/error-node-too-old-1': return '[错误]: 你安装的Nnode.js版本过老,无法支持tera工具箱运行!';
        case 'loader-cli/error-node-too-old-2': return '[错误]: 请重新下载并安装tera工具箱,或安装最新版的Node.js.下载地址: https://nodejs.org/en/download/current/';
        case 'loader-cli/error-runtime-incompatible-default': return `[错误]: ${tokens.message}`;
        case 'loader-cli/error-config-corrupt-1': return '[错误]: 哦嚯,看上去似乎你把config.json配置错了!';
        case 'loader-cli/error-config-corrupt-2': return `[错误]:请尝试自己解决,或在这里提问: ${tokens.supportUrl}`;
        case 'loader-cli/error-migration-failed-1': return '[错误]: 无法从旧版本tera工具箱中迁移文件!';
        case 'loader-cli/error-migration-failed-2': return '[错误]: 请使用最新完整的安装程序重新安装.';
        case 'loader-cli/error-migration-failed-3': return `[错误]: 或在这里体提问: ${tokens.supportUrl}`;
        case 'loader-cli/error-cannot-start-proxy': return '[tera工具箱] 无法启动网络代理, 程序终止...';
        case 'loader-cli/terminating': return '程序终止中...';
        case 'loader-cli/warning-noupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-cli/warning-noupdate-2': return '!!!!!                 你把所有的自动更新都关闭了               !!!!!';
        case 'loader-cli/warning-noupdate-3': return '!!!!! 你将不会得到任何技术支持(漏洞修复/操作码更新/插件更新等) !!!!!';
        case 'loader-cli/warning-noupdate-4': return '!!!!!            你要为自己的这个举动承担相应的后果            !!!!!';
        case 'loader-cli/warning-noupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-cli/warning-update-mod-not-supported': return `[更新错误]: 插件: ${tokens.name} 不支持自动更新!`;
        case 'loader-cli/error-update-mod-failed': return `[更新错误]: 插件: ${tokens.name} 无法更新，可能已损坏 !`;
        case 'loader-cli/error-update-failed': return '[更新错误]: 无法自动更新! 完整的日子显示如下:';

        // loader-gui
        case 'loader-gui/tray/quit': return '退出';
        case 'loader-gui/error-config-file-corrupt/title': return '无效的配置文件!';
        case 'loader-gui/error-config-file-corrupt/message': return `tera工具箱文件夹下的config.json配置文件有问题. 请尝试自己修复, 例如先删除它让程序自动生成一个, 如果还有问题请到这里提问: ${tokens.supportUrl} for help!\n\n程序即将被终止.`;
        case 'loader-gui/error-migration-failed/title': return '文件迁移过程中发生错误!';
        case 'loader-gui/error-migration-failed/message': return `无法从旧版本的tera工具箱中迁移文件.\n请使用最新的安装程序重新安装一个干净的tera工具箱,然后在进行尝试.或请在这个链接下提问: ${tokens.supportUrl} for help!\n\n程序即将被终止.`;
        case 'loader-gui/error-cannot-start-proxy': return '[tera工具箱] 无法启动网络代理功能!';
        case 'loader-gui/terminating': return '程序正在终止...';
        case 'loader-gui/warning-noselfupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noselfupdate-2': return '!!!!!                   您已禁用自动自更新                     !!!!!';
        case 'loader-gui/warning-noselfupdate-3': return '!!!!! 你将不会得到任何技术支持(漏洞修复/操作码更新/插件更新等) !!!!!';
        case 'loader-gui/warning-noselfupdate-4': return '!!!!!           你要为自己的这个举动承担相应的后果             !!!!!';
        case 'loader-gui/warning-noselfupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noupdate-2': return '!!!!!                 你把所有的自动更新都关闭了               !!!!!';
        case 'loader-gui/warning-noupdate-3': return '!!!!! 你将不会得到任何技术支持(漏洞修复/操作码更新/插件更新等) !!!!!';
        case 'loader-gui/warning-noupdate-4': return '!!!!!            你要为自己的这个举动承担相应的后果            !!!!!';
        case 'loader-gui/warning-noupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-update-mod-not-supported': return `[更新警告]: 插件 ${tokens.name} 不支持自动更新!`;
        case 'loader-gui/error-update-mod-failed': return `[更新错误]: 插件 ${tokens.name} 不能被更新，文件可能已经损坏.`;
        case 'loader-gui/error-update-failed': return '[更新错误]: 无法执行自动更新! 完整的错误日志如下:';
        case 'loader-gui/proxy-starting': return '[tera工具箱] 正在启动网络代理...';
        case 'loader-gui/proxy-stopping': return '[tera工具箱] 正在停止网络代理...';
        case 'loader-gui/proxy-stopped': return '[tera工具箱] 网络代理已停止!';
        case 'loader-gui/mod-installed': return `[tera工具箱] 已安装: "${tokens.name}"`;
        case 'loader-gui/mod-uninstalled': return `[tera工具箱] 已卸载: "${tokens.name}"`;
        case 'loader-gui/mod-load-toggled': return `[tera工具箱] ${tokens.enabled ? 'Enabled' : 'Disabled'} "${tokens.name}"`;
        case 'loader-gui/mod-updates-toggled': return `[tera工具箱] ${tokens.updatesEnabled ? 'Enabled' : 'Disabled'} 已自动更新模组: "${tokens.name}"`;

        // proxy
        case 'proxy/ready': return '[tera工具箱] 程序准备完成, 正在等待游戏客户端运行!';
        case 'proxy/client-interface-error': return '[tera工具箱] 错误: 无法启动客户端连接服务器.';
        case 'proxy/client-interface-error-EADDRINUSE': return '[tera工具箱] 错误: 已经存在另外一个tera工具箱在运行. 请关闭它,或重新启动电脑再进行尝试!';
        case 'proxy/client-interface-error-EADDRNOTAVAIL': return '[tera工具箱] 错误: IP地址不可用. 请尝试重启电脑,再尝试一次!';
        case 'proxy/client-interface-connection-error': return `[tera工具箱] 无法与客户端建立连接: ${tokens.error}`;
        case 'proxy/client-interface-connected': return `[tera工具箱] 客户端 ${tokens.justStarted ? 'connected' : 'reconnected'} (${tokens.publisher.toUpperCase()} ,版本号: ${tokens.majorPatchVersion}.${tokens.minorPatchVersion})`;
        case 'proxy/client-interface-disconnected': return `[tera工具箱] 客户端断开连接.`;
        case 'proxy/redirecting-server': return `[tera工具箱] ${tokens.name} (${tokens.publisher.toUpperCase()}-${tokens.serverId}) 从 ${tokens.listen_ip}:${tokens.listen_port} 定向到 ${tokens.ip}:${tokens.port}`;
        case 'proxy/warning-unmapped-protocol-1': return `[tera工具箱] 警告: 未映射的协议版本 ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} 版本号:${tokens.majorPatchVersion}.${tokens.minorPatchVersion}).`;
        case 'proxy/warning-unmapped-protocol-2': return '[tera工具箱] 警告: 这可能是由以下原因造成的:';
        case 'proxy/warning-unmapped-protocol-3': return '[tera工具箱] 警告: 1) 您正在尝试使用尚未支持的新客户端版本.';
        case 'proxy/warning-unmapped-protocol-4': return '[tera工具箱] 警告:    如果在过去的几个小时内有游戏维护，请上报!';
        case 'proxy/warning-unmapped-protocol-5': return '[tera工具箱] 警告:    不管怎么说，您的客户端可能领先别的服更新了版本.';
        case 'proxy/warning-unmapped-protocol-6': return '[tera工具箱] 警告: 2) 您正在尝试使用过时的客户端版本.';
        case 'proxy/warning-unmapped-protocol-7': return '[tera工具箱] 警告:    尝试客户端修复或重新安装游戏解决这个问题!';
        case 'proxy/warning-unmapped-protocol-8': return `[tera工具箱] 警告: 如果你没办法独自解决这个问题, 你可以在这里寻求帮助: ${tokens.supportUrl}!`;
        case 'proxy/error-cannot-load-protocol': return `[错误]: 无法加载协议: ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} ,版本号: ${tokens.majorPatchVersion}.${tokens.minorPatchVersion})!`;
        case 'proxy/protocol-loaded': return `[tera工具箱] 已加载协议: ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} ,版本号: ${tokens.majorPatchVersion}.${tokens.minorPatchVersion}).`;
        case 'proxy/error-installing-gpks': return '错误: 无法安装GPK插件! 完整的错误信息如下:';

        // update
        case 'update/started': return '[更新] 自动更新已开始!';
        case 'update/core-module-initialized': return `[更新] 已初始化核心插件: "${tokens.coreModule}"`;
        case 'update/dependency-module-initialized': return `[更新] 已初始化插件:"${tokens.name}"的依赖关系:"${tokens.dependency}"`;
        case 'update/warning-module-update-disabled': return `[更新警告]: 插件: ${tokens.name}的自动更新被关闭!`;
        case 'update/start-module-install': return `[更新] 正在安装插件: ${tokens.name}`;
        case 'update/start-module-update': return `[更新] 正在更新插件: ${tokens.name}`;
        case 'update/warning-module-no-update-servers': return `[更新警告]: 插件: ${tokens.name} 没有指定任何更新地址!`;
        case 'update/module-download-manifest': return `[更新] - 正在检索更新: (地址： ${tokens.serverIndex})`;
        case 'update/module-download-file': return `[更新] - 下载: ${tokens.file}`;
        case 'update/module-config-changed': return '[更新] - 插件的配置文件已变更, 正在重新启动更新!';
        case 'update/module-update-failed-1': return `[更新] 错误: 无法更新插件:  ${tokens.name}:`;
        case 'update/module-update-failed-2-1': return `[更新] 请访问: ${tokens.supportUrl} ,然后按照给出的指示操作，或寻求帮助.`;
        case 'update/module-update-failed-2-2': return `[更新] 或者在这里提问: ${tokens.supportUrl}`;
        case 'update/module-update-failed-3': return `[更新] 请联系插件作者，或在这里提问: ${tokens.supportUrl}`;
        case 'update/finished': return '[更新] 自动更新结束!';

        // gui
        case 'gui/tooltip/download': return '下载插件';
        case 'gui/tooltip/remove': return '移除插件';
        case 'gui/tooltip/toggleMod': return '开启/关闭 插件';
        case 'gui/tooltip/toggleModAutoupdate': return '开启/关闭 插件自动更新';
        case 'gui/tooltip/donate': return '赞助作者';
        case 'gui/tooltip/supportLink': return '访问插件支持网页';        
        case 'gui/tooltip/readme': return '打开说明';

        case 'gui/main/title': return 'TERA 工具箱';
		case 'gui/main/title/admin': return 'tera工具箱 [管理员运行模式]';
        case 'gui/main/title/noadmin': return 'tera工具箱[普通运行模式]';
        
        case 'gui/main/start-stop-proxy-running': return '停止';
        case 'gui/main/start-stop-proxy-not-running': return '开始';
        case 'gui/main/start-stop-proxy-starting': return '正在启动...';
        case 'gui/main/start-stop-proxy-stopping': return '正在关闭...';

        case 'gui/main/status-proxy-running': return '正在运行';
        case 'gui/main/status-proxy-not-running': return '没有运行';
        case 'gui/main/status-update-available': return '更新功能已启动 - 请重新打开';

        case 'gui/main/modal/buttons/ok': return '确认';
        case 'gui/main/modal/warn-mod-update-disabled': return '警告! 你关闭了针对所有模组的自动更新开关. 这在某种程度上会破坏一些东西. 除非重新启用，否则程序将不会提供任何插件更新!';
        case 'gui/main/modal/warn-self-update-disabled': return '警告! 你关闭了针对tera工具箱的自动更新开关. 这在某种程度上会破坏一些东西. 除非重新启用，否则tera工具箱本身将不会再更新!';
        case 'gui/main/modal/error-cannot-install-mod-while-running': return '你无法在tera具箱运行的时候安装插件. 请先停止程序!';
        case 'gui/main/modal/error-cannot-uninstall-mod-while-running': return '你无法在tera工具箱运行的时候卸载插件. 请先停止程序!';

        case 'gui/main/static/tabs/log/title': return '日志';
        case 'gui/main/static/tabs/log/loading': return '正在加载代理日志...';

        case 'gui/main/static/tabs/mods/title': return '我的插件';
        case 'gui/main/static/tabs/mods/loading': return '正在加载已安装的插件...';

        case 'gui/main/static/tabs/newmods/title': return '取得更多插件';
        case 'gui/main/static/tabs/newmods/loading': return '正在加载插件列表...';
        case 'gui/main/static/tabs/newmods/content/filter': return '过滤: ';
        case 'gui/main/static/tabs/newmods/content/filter/network': return '在线 / 代理插件';
        case 'gui/main/static/tabs/newmods/content/filter/client': return '客户端 / UI插件';

        case 'gui/main/static/tabs/settings/title': return '设置';
        case 'gui/main/static/tabs/settings/groupclient': return 'Game client:';
        case 'gui/main/static/tabs/settings/toolbox': return 'Tera Toolbox:';
        case 'gui/main/static/tabs/settings/loading': return '正在加载设置...';
        case 'gui/main/static/tabs/settings/content/uilanguage': return '语言';
        case 'gui/main/static/tabs/settings/content/theme': return '主题';
        case 'gui/main/static/tabs/settings/content/autostart': return '在打开tera工具箱时自动运行代理程序';
        case 'gui/main/static/tabs/settings/content/updatelog': return '显示详细的更新日志';
        case 'gui/main/static/tabs/settings/content/logtimes': return '在日志中显示时间';
        case 'gui/main/static/tabs/settings/content/noupdate': return '关闭插件更新';
        case 'gui/main/static/tabs/settings/content/noselfupdate': return '禁用主程序更新';
        case 'gui/main/static/tabs/settings/content/devmode': return '启用开发者模式';
        case 'gui/main/static/tabs/settings/content/noslstags': return '在服务器列表中隐藏代理标记';
		case 'gui/main/static/tabs/settings/content/noserverautojoin': return '关闭自动连接到游戏服务器';
        case 'gui/main/static/tabs/settings/content/minimizetotray': return '最小化到系统托盘';
        case 'gui/main/static/tabs/settings/content/removecounters': return '在服务器列表中隐藏计数器';
        case 'gui/main/static/tabs/settings/content/cleanstart': return '每一次teratoolbox启动时清空日志';

        case 'gui/main/static/tabs/help/title': return '需要帮助?';

        case 'gui/main/static/tabs/modsfolder/title': return '显示插件文件夹';

        case 'gui/main/static/tabs/credits/title': return '工作人员';
        case 'gui/main/static/tabs/credits/loading': return '加载工作人员...';
        case 'gui/main/static/tabs/credits/content': return 'Thanks to<br />SaltyMonkey: Installer/Modern UI stuff<br />Mathicha &amp; Pentagon: Old GUI stuff<br />Foglio: Logo design<br />Meishu: Original Tera-Proxy Core<br />All Toolbox Translators<br />All Mod Developers';

        // tera-client-interface
        case 'tera-client-interface/index/communication-error': return '[tera工具箱] 与客户端通信连接错误:';

        case 'tera-client-interface/gpkmanager/symlink-warning-1': return '[tera工具箱] 警告: 它看起来要么tera工具箱或游戏都位于同一个磁盘上 / 请分区后在存放';
        case 'tera-client-interface/gpkmanager/symlink-warning-2': return '[tera工具箱] 警告: 磁盘格式不支持 (例如游戏存放的磁盘的磁盘格式使用的是exFAT或FAT32)!';
        case 'tera-client-interface/gpkmanager/symlink-warning-3': return '[tera工具箱] 警告: 作为备份，您的客户端插件将通过创建文件副本的形式来安装.';
        case 'tera-client-interface/gpkmanager/symlink-warning-4': return '[tera工具箱] 警告: 注意，这可能会减慢客户端的启动时间，并对磁盘造成压力!';
        case 'tera-client-interface/gpkmanager/uninstall-error-1': return '[tera工具箱] 警告: 无法删除下列客户端插件文件:';
        case 'tera-client-interface/gpkmanager/uninstall-error-2': return `[tera工具箱] 警告: ${tokens.fullPath}`;
        case 'tera-client-interface/gpkmanager/uninstall-error-3': return '[tera工具箱] 警告: 它会在你下次开始游戏时被删除.您也可以手动删除它.';

        // mod
        case 'mod/prefix-log': return `[${tokens.name}]`;
        case 'mod/prefix-warn': return `[${tokens.name}] 警告:`;
        case 'mod/prefix-error': return `[${tokens.name}] 错误:`;
        case 'mod/settings-load-error-corrupted-1': return '您上次使用完程序后，关闭不当!';
        case 'mod/settings-load-error-corrupted-2': return `这导致了插件: "${tokens.name}" 的设置发生问题!`;
        case 'mod/settings-load-error-corrupted-3': return '该插件将加载默认设置，请根据您的需要进行调整.';
        case 'mod/settings-load-error-corrupted-4': return '请记住正确关闭程序的过程:首先关闭游戏，然后使用X按钮关闭tera工具箱!';
        case 'mod/settings-load-error-corrupted-5': return '请不要再tera工具箱运行的时候关闭电脑!';
        case 'mod/settings-load-error-invalid-format-1': return `[插件错误]: "${tokens.name}的配置文件无效"!`;
        case 'mod/settings-load-error-invalid-format-2': return '这意味着,您在手动编辑它的时候破坏了它.';
        case 'mod/settings-load-error-invalid-format-3': return '请手动修复配置文件,或删除它，以便程序自动生成默认的配置文件.';
        case 'mod/settings-load-error-invalid-format-4': return '------------------------------------------';
        case 'mod/settings-load-error-invalid-format-5': return '先前错误的详细内容:';
        case 'mod/settings-load-error-invalid-format-6': return '文件的完整路径:';
        case 'mod/settings-load-error-invalid-format-7': return `  ${tokens.settingsFile}`;
        case 'mod/settings-load-error-invalid-format-8': return '完整的错误日志如下:';
        case 'mod/settings-load-error-invalid-format-9': return `  ${tokens.e}`;
        case 'mod/settings-load-error-invalid-format-10': return '------------------------------------------';
        case 'mod/settings-save-error-write': return '无法保存配置! 完整的错误日志如下:';
        case 'mod/settings-save-error-stringify': return '无法连载配置! 完整的错误日志如下:';
        case 'mod/settings-migrate-error-load-migrator': return '无法加载配置迁移! 完整的错误日志如下:';
        case 'mod/settings-migrate-error-run-migrator': return '迁移设置过程中发生错误! 完整的错误日志如下:';
        case 'mod/tera-game-state-not-loaded': return '这个插件可能会出现故障，因为"tera-game-state"无法加载.';
        case 'mod/client-install-error-1': return `安装客户端组件时发生错误!`;
        case 'mod/client-install-error-2': return `请联系插件作者: ${tokens.supportUrl}`;
        
        case 'mod/mod-preloaded': return `[插件] 预加载插件: ${tokens.name}`;
        case 'mod/mod-preload-error-1': return `[插件] 错误: 无法预加载插件: ${tokens.name}`;
        case 'mod/mod-preload-error-2': return `[插件] 错误: 请联系插件作者: ${tokens.supportUrl}`;
        case 'mod/mod-unloaded': return `[插件] 未加载插件: ${tokens.name}`;
        case 'mod/mod-reloaded': return `[插件] 已重新加载插件: ${tokens.name}`;
        
        case 'mod/mod-global-instance-loaded': return `[插件] 已运行插件: ${tokens.name}`;
        case 'mod/mod-global-instance-load-error-1': return `[插件] 错误: 无法运行插件: ${tokens.name}`;
        case 'mod/mod-global-instance-load-error-2': return `[插件] 错误: 请联系插件作者: ${tokens.supportUrl}`;
        case 'mod/mod-global-instance-unloaded': return `[插件] 已停止运行插件: ${tokens.name}`;
        case 'mod/mod-global-instance-unload-error-1': return `[插件] 错误: 无法停止插件: ${tokens.name}`;
        case 'mod/mod-global-instance-unload-error-2': return `[插件] 错误: 请联系插件作者: ${tokens.supportUrl}`;
        
        case 'mod/mod-client-instance-loaded': return `[插件] 插件: ${tokens.name} 已连接到客户端.`;
        case 'mod/mod-client-instance-load-error-1': return `[插件] 错误: 插件: ${tokens.name} 无法连接到客户端!`;
        case 'mod/mod-client-instance-load-error-2': return `[插件] 错误: 请联系插件作者: ${tokens.supportUrl}`;
        case 'mod/mod-client-instance-unloaded': return `[插件] 插件: ${tokens.name} 与客户端已断开连接.`;
        case 'mod/mod-client-instance-unload-error-1': return `[插件] 错误: 插件: ${tokens.name} 无法与客户端断开连接!`;
        case 'mod/mod-client-instance-unload-error-2': return `[插件] 错误: 请联系插件作者: ${tokens.supportUrl}`;
        
        case 'mod/mod-network-instance-loaded': return `[插件] 插件: ${tokens.name} 已连接到服务器`;
        case 'mod/mod-network-instance-load-error-1': return `[插件] 错误: 插件: ${tokens.name} 无法连接到服务器!`;
        case 'mod/mod-network-instance-load-error-2': return `[插件] 错误: 请联系插件作者: ${tokens.supportUrl}`;
        case 'mod/mod-network-instance-unloaded': return `[插件] 插件: ${tokens.name} 与服务器已断开连接`;
        case 'mod/mod-network-instance-unload-error-1': return `[插件] 错误: 插件: ${tokens.name} 无法与服务器断开连接!`;
        case 'mod/mod-network-instance-unload-error-2': return `[插件] 错误: 请联系插件作者: ${tokens.supportUrl}`;

        // mod-manager
        case 'mod-manager/load-module-info-error': return `[插件错误]: 无法获取插件: "${tokens.name}"的信息! 完整的错误日志如下:`;
        case 'mod-manager/duplicate-mod-error': return `[插件错误]: 检测到插件: "${tokens.name}"存在重复插件!`;
        case 'mod-manager/missing-mod-dependency-error': return `[插件错误]: 插件: ${tokens.name} 需要安装: "${tokens.dependency}" , 但是后者没有安装!`;
        case 'mod-manager/mod-conflict-error': return `[插件错误]: 插件: ${tokens.name} 无法在安装: "${tokens.conflict}"的情况下加载!`;
        case 'mod-manager/cannot-load-mod-not-installed': return `[插件错误]: 尝试加载未安装的插件: ${tokens.name}`;
        case 'mod-manager/cannot-unload-mod-not-installed': return `[插件错误]: 尝试卸载未加载的插件: ${tokens.name}`;
        case 'mod-manager/cannot-unload-mod-not-loaded': return `[插件错误]: 尝试卸载未加载的插件: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-installed': return `[插件错误]: 尝试重新加载未安装的插件: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-supported': return `[插件错误]: 尝试重新加载不支持热加载的插件: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-loaded': return `[插件错误]: 尝试重新加载未加载的插件: ${tokens.name}`;

        // default
        default: throw new Error(`Invalid string "${str}"!`);
    }
};

module.exports = { Name, GetString };