// Turkish translation by Primus#4514 and Zdizisiek#8369

const Name = 'Türkçe';

function GetString(str, tokens) {
    switch (str) {
        // connection-manager
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-1': return `[Bağlantı] HATA: Oyun sunucularına bağlanılamadı ${tokens.address}:${tokens.port} (${tokens.code})! Buna sebep olan sorunlar:`;
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-2': return '[Bağlantı] - Stabil olmayan bir internet bağlantısı veya IP-Ban';
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-3': return '[Bağlantı] - Oyun sunucularında bakım olması durumu';
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-1': return `[Bağlantı] HATA: ${tokens.code} - Oyun sunucularıyla olan bağlantı beklenmedik bir şekilde kapandı. Buna sebep olabilecek sorunlar:`;
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-2': return '[Bağlantı] - Stabil olmayan bir internet bağlantısı';
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-3': return '[Bağlantı] - Oyundan atılmanıza neden olabilecek bir hile/mod sebebiyle oyundan atıldınız';
        case 'connection-manager/connected': return `[Bağlantı] Yönlendiriliyor ${tokens.remote} to ${tokens.remoteAddress}:${tokens.remotePort}`;
        case 'connection-manager/disconnected': return `[Bağlantı] ${tokens.remote} Sunucuyla bağlantı kesildi`;

        // loader-cli
        case 'loader-cli/error-node-too-old-1': return 'HATA: Yüklü olan node.js versiyonunuz TeraToolbox çalıştıramayacak kadar eski!';
        case 'loader-cli/error-node-too-old-2': return 'HATA: Lütfen TeraToolboxu tekrar indirin ve yükleyin, veya buradan node.js uygulamasının son versiyonunu indirin https://nodejs.org/en/download/current/';
        case 'loader-cli/error-runtime-incompatible-default': return `HATA: ${tokens.message}`;
        case 'loader-cli/error-config-corrupt-1': return 'HATA: Oops! Görünen o ki config.js dosyanı bozmuşsun!';
        case 'loader-cli/error-config-corrupt-2': return `HATA: Kendin düzeltmeyi dene veya buradan yardım isteyebilirsin: ${tokens.supportUrl}`;
        case 'loader-cli/error-migration-failed-1': return 'HATA: TERA Toolboxun eski versiyonlarından dosya aktarımı başarısız oldu!';
        case 'loader-cli/error-migration-failed-2': return 'HATA: Lütfen guncel bir yükleyici ile temiz bir kurulum yapın.';
        case 'loader-cli/error-migration-failed-3': return `HATA: ve buradan yardım isteyebilirsin: ${tokens.supportUrl}`;
        case 'loader-cli/error-cannot-start-proxy': return '[ToolBox] Network proxy başlatılamadı, sonlandırılıyor...';
        case 'loader-cli/terminating': return 'sonlandırılıyor...';
        case 'loader-cli/warning-noupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-cli/warning-noupdate-2': return '!!!!!    OTOMATİK GÜNCELLEMELERİ DEVRE DIŞI BIRAKTINIZ      !!!!!';
        case 'loader-cli/warning-noupdate-3': return '!!!!!   BUNU GERÇEKLEŞTİRDİĞİN İÇİN İLERİDE YAŞAYACAĞINIZ   !!!!!';
        case 'loader-cli/warning-noupdate-4': return '!!!!!      	SORUNLARA DESTEK SAĞLANMAYACAKTIR             !!!!!';
        case 'loader-cli/warning-noupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-cli/warning-update-mod-not-supported': return `[Güncelleme] Uyari: Bu mod ${tokens.name} otomatik guncellemeyi desteklemiyor!`;
        case 'loader-cli/error-update-mod-failed': return `[Güncelleme] HATA: Bu mod ${tokens.name} güncellenemiyor veya bozuk!`;
        case 'loader-cli/error-update-failed': return 'HATA: Otomatik güncelleme gerçekleştirilemiyor! Hata metninin tamamı:';

        // loader-gui
        case 'loader-gui/tray/quit': return 'Çıkış';
        case 'loader-gui/error-config-file-corrupt/title': return 'Geçersiz ayar dosyası';
        case 'loader-gui/error-config-file-corrupt/message': return `TeraToolbox dosyanızın içindeki config.json dosyası kötü biçimlendirilmiş veya kusurlu. Kendiniz düzeltmeyi deneyin, yeni bir tane oluşturmak için silin, veya buradan ${tokens.supportUrl} yardım isteyin!\n\nProgram şimdi kapatılacaktır.`;
        case 'loader-gui/error-migration-failed/title': return 'Dosya aktarım hatası!';
        case 'loader-gui/error-migration-failed/message': return `TeraToolboxun eski versiyonundan dosya aktarımı başarısız oldu.\nLütfen güncel yükleyiciyi kullanarak temiz bir kurulum yapın veya buradan ${tokens.supportUrl} yardım isteyin!\n\nProgram şimdi kapatılacaktır.`;
        case 'loader-gui/error-cannot-start-proxy': return '[ToolBox] Network proxy başlatılamadı!';
        case 'loader-gui/terminating': return 'sonlandirılıyor...';
        case 'loader-gui/warning-noselfupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noselfupdate-2': return '!!!!!      OTOMATİK GÜNCELLEMELERİ DEVRE DIŞI BIRAKTINIZ    !!!!!';
        case 'loader-gui/warning-noselfupdate-3': return '!!!!!    BUNU GERÇEKLEŞTİRDİĞİN İÇİN İLERİDE YAŞAYACAĞINIZ  !!!!!';
        case 'loader-gui/warning-noselfupdate-4': return '!!!!!      	SORUNLARA DESTEK SAĞLANMAYACAKTIR             !!!!!';
        case 'loader-gui/warning-noselfupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noupdate-2': return '!!!!!      OTOMATIK GÜNCELLEMELERİ DEVRE DIŞI BIRAKTINIZ    !!!!!';
        case 'loader-gui/warning-noupdate-3': return '!!!!! 	BUNU GERÇEKLEŞTİRDİĞİN İÇİN İLERİDE YAŞAYACAĞINIZ !!!!!';
        case 'loader-gui/warning-noupdate-4': return '!!!!!     	 SORUNLARA DESTEK SAĞLANMAYACAKTIR 		      !!!!!';
        case 'loader-gui/warning-noupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-update-mod-not-supported': return `[Güncelleme] UYARI: Bu mod ${tokens.name} otomatik güncellemeyi desteklemiyor!`;
        case 'loader-gui/error-update-mod-failed': return `[Güncelleme] HATA: Bu mod ${tokens.name} yüklenemedi veya hasarlı!`;
        case 'loader-gui/error-update-failed': return 'HATA: Otomatik güncelleme gerçekleştirilemiyor! Hata metninin tamamı:';
        case 'loader-gui/proxy-starting': return '[ToolBox] Network Proxy başlatılıyor...';
        case 'loader-gui/proxy-stopping': return '[ToolBox] Network Proxy durduruluyor...';
        case 'loader-gui/proxy-stopped': return '[ToolBox] Network Proxy durduruldu!';
        case 'loader-gui/mod-installed': return `[ToolBox] Yüklendi "${tokens.name}"`;
        case 'loader-gui/mod-uninstalled': return `[ToolBox] Kaldırıldı "${tokens.name}"`;
        case 'loader-gui/mod-load-toggled': return `[ToolBox] ${tokens.enabled ? 'Enabled' : 'Disabled'} "${tokens.name}"`;
        case 'loader-gui/mod-updates-toggled': return `[ToolBox] ${tokens.updatesEnabled ? 'Enabled' : 'Disabled'} automatic updates for "${tokens.name}"`;

        // proxy
        case 'proxy/ready': return '[ToolBox] Hazır, oyun istemcisinin başlatılması bekleniyor!';
        case 'proxy/client-interface-error': return '[ToolBox] HATA: İstemci arayüz sunucusu başlatılamadı.';
        case 'proxy/client-interface-error-EADDRINUSE': return '[ToolBox] HATA: Başka bir TeraToolbox çalışıyor. Lütfen açık olan TeraToolboxı kapatın veya bilgisayarınız yeniden başlatıp tekrar deneyin!';
        case 'proxy/client-interface-error-EADDRNOTAVAIL': return '[ToolBox] HATA: Adres kullanılamıyor. Bilgisayarınızı yeniden başlatın ve tekrar deneyin!';
        case 'proxy/client-interface-connection-error': return `[ToolBox] İstemci bağlantısı gerçekleştirilemedi: ${tokens.error}`;
        case 'proxy/client-interface-connected': return `[ToolBox] İstemci ${tokens.justStarted ? 'connected' : 'reconnected'} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion})`;
        case 'proxy/client-interface-disconnected': return `[ToolBox] İstemci bağlantısı kesildi`;
        case 'proxy/redirecting-server': return `[ToolBox] Yönlendiriliyor ${tokens.name} (${tokens.publisher.toUpperCase()}-${tokens.serverId}) buradan ${tokens.listen_ip}:${tokens.listen_port} buraya ${tokens.ip}:${tokens.port}`;
        case 'proxy/warning-unmapped-protocol-1': return `[ToolBox] UYARI: Atanmayan protocol sürümü ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion}).`;
        case 'proxy/warning-unmapped-protocol-2': return '[ToolBox] UYARI: Buna aşağıdaki sebeplerden herhangi birisi sebep olabilir:';
        case 'proxy/warning-unmapped-protocol-3': return '[ToolBox] UYARI: 1) Henuz yeni yayınlanmış ve desteklenmeyen bir istemci sürümü ile oynayamayı deniyorsunuz.';
        case 'proxy/warning-unmapped-protocol-4': return '[ToolBox] UYARI:    Eğer geçtiğimiz saatlerde bir sunucu bakımı gerçekleştiyse, lütfen bildirin!';
        case 'proxy/warning-unmapped-protocol-5': return '[ToolBox] UYARI:    Aksi takdirde, istemciniz yeni gelecek olan bir güncelleme için önceden güncellenmiş olabilir.';
        case 'proxy/warning-unmapped-protocol-6': return '[ToolBox] UYARI: 2) Güncel olmayan bir istemci sürümü kullanarak oynamayı deniyorsunuz.';
        case 'proxy/warning-unmapped-protocol-7': return '[ToolBox] UYARI:    Bunu düzeltmek için istemcinizi onarmayı deneyin veya oyunu sıfırdan kurun!';
        case 'proxy/warning-unmapped-protocol-8': return `[ToolBox] UYARI: Eğer kendi başınıza düzeltemediyseniz, buradan yardım isteyin: ${tokens.supportUrl}!`;
        case 'proxy/error-cannot-load-protocol': return `HATA: Protokol sürümü yüklenemedi ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion})!`;
        case 'proxy/protocol-loaded': return `[ToolBox] Yüklenen protokol sürümü ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion}).`;
        case 'proxy/error-installing-gpks': return 'HATA: GPK Modları yüklenemedi! Hata mesajının tamamı:';

        // update
        case 'update/started': return '[Güncelleme] Otomatik güncelleme başladı!';
        case 'update/core-module-initialized': return `[Güncelleme] Gerekli modlar başlatıldı "${tokens.coreModule}"`;
        case 'update/dependency-module-initialized': return `[Güncelleme] Gereklilikler başlatıldı "${tokens.dependency}" for module "${tokens.name}"`;
        case 'update/warning-module-update-disabled': return `[Güncelleme] UYARI: Otomatik güncelleme bu mod için devre dışı bırakıldı! ${tokens.name}!`;
        case 'update/start-module-install': return `[Güncelleme] Yüklenen mod ${tokens.name}`;
        case 'update/start-module-update': return `[Güncelleme] Güncellenen mod ${tokens.name}`;
        case 'update/warning-module-no-update-servers': return `[Güncelleme] UYARI: Bu mod ${tokens.name} herhangi bir güncelleme sunucusu belirtmedi!`;
        case 'update/module-download-manifest': return `[Güncelleme] - Güncelleme bilgileri alınıyor. (Server ${tokens.serverIndex})`;
        case 'update/module-download-file': return `[Güncelleme] - İndir ${tokens.file}`;
        case 'update/module-config-changed': return '[Güncelleme] - Modül özellikleri değiştirildi, Güncelleme yeniden başlatılıyor!';
        case 'update/module-update-failed-1': return `[Güncelleme] ERROR: Bu mod otomatik güncellenemedi ${tokens.name}:`;
        case 'update/module-update-failed-2-1': return `[Güncelleme] Lütfen buraya gidin ${tokens.supportUrl} ve yazılanları yerine getirin veya yardım isteyin.`;
        case 'update/module-update-failed-2-2': return `[Güncelleme] Alternatif olarak, buraya sorun: ${tokens.supportUrl}`;
        case 'update/module-update-failed-3': return `[Güncelleme] Lütfen modu yazan kişiyle iletişime geçin veya buraya sorun: ${tokens.supportUrl}`;
        case 'update/finished': return '[Güncelleme] Otomatik güncelleme tamamlandı!';

        // gui
        case 'gui/tooltip/download': return 'Modu İndir';
        case 'gui/tooltip/remove': return 'Modu Kaldır';
        case 'gui/tooltip/toggleMod': return 'Modu Aktifleştir/Pasifleştir';
        case 'gui/tooltip/toggleModAutoupdate': return 'Modun Otomatik Güncelleştirmesini Aç/Kapat';
        case 'gui/tooltip/donate': return 'Modun Sahibine Bağış Yap';
        case 'gui/tooltip/supportLink': return 'Destek Sayfasını Ziyaret Et';
        case 'gui/tooltip/readme': return 'Dosyayı bilgi içeriğiyle aç';
        case 'gui/main/static/tabs/settings/content/removecounters': return 'Sunucu listesindeki etiketleri gizle';
        case 'gui/main/static/tabs/settings/content/cleanstart': return 'Toolbox Geçmişini her açılışta temizle'; 

        case 'gui/main/title': return 'TERA Toolbox';
        
        case 'gui/main/start-stop-proxy-running': return 'Durdur';
        case 'gui/main/start-stop-proxy-not-running': return 'Başlat';
        case 'gui/main/start-stop-proxy-starting': return 'Başlatılıyor...';
        case 'gui/main/start-stop-proxy-stopping': return 'Durduruluyor...';

        case 'gui/main/status-proxy-running': return 'Çalışıyor';
        case 'gui/main/status-proxy-not-running': return 'Çalışmıyor';
        case 'gui/main/status-update-available': return 'GÜNCELLEME KULLANILABİLİR - LÜTFEN YENİDEN BAŞLATIN';

        case 'gui/main/modal/buttons/ok': return 'TAMAM';
        case 'gui/main/modal/warn-mod-update-disabled': return 'Uyarı! Tüm modlarınız için otomatik güncellemeleri devre dışı bıraktınız. Bu durum bir noktadan sonra bazı bozukluklar yaratacaktır. Otomatik güncelleştirmeler tekrar etkinleştirilene kadar destek sağlamayacağız!';
        case 'gui/main/modal/warn-self-update-disabled': return 'Uyarı! TERA ToolBox için otomatik güncellemeleri devre dışı bıraktınız. Bu durum bir noktadan sonra bazı bozukluklar yaratacaktır. Otomatik güncelleştirmeler tekrar etkinleştirilene kadar destek sağlamayacağız!';
        case 'gui/main/modal/error-cannot-install-mod-while-running': return 'TERA ToolBox çalışırken herhangi bir mod yükleyemezsiniz. Lütfen önce durdurun!';
        case 'gui/main/modal/error-cannot-uninstall-mod-while-running': return 'TERA ToolBox çalışırken mod herhangi bir mod kaldıramazsınız. Lütfen önce durdurun!';

        case 'gui/main/static/tabs/log/title': return 'Kayıt';
        case 'gui/main/static/tabs/log/loading': return 'Proxy kayıtları yükleniyor...';

        case 'gui/main/static/tabs/mods/title': return 'Modlarım';
        case 'gui/main/static/tabs/mods/loading': return 'Yüklü modlar görüntüleniyor...';

        case 'gui/main/static/tabs/newmods/title': return 'Daha Fazla Mod';
        case 'gui/main/static/tabs/newmods/loading': return 'Modların listesi yükleniyor...';
        case 'gui/main/static/tabs/newmods/content/filter': return 'Filtre: ';
        case 'gui/main/static/tabs/newmods/content/filter/network': return 'Network / Proxy Modları';
        case 'gui/main/static/tabs/newmods/content/filter/client': return 'Client / Arayüz Modları';

        case 'gui/main/static/tabs/settings/title': return 'Ayarlar';
        case 'gui/main/static/tabs/settings/groupclient': return 'Game client:';
        case 'gui/main/static/tabs/settings/toolbox': return 'Tera Toolbox:';
        case 'gui/main/static/tabs/settings/loading': return 'Ayarlar yükleniyor...';
        case 'gui/main/static/tabs/settings/content/uilanguage': return 'Dil';
        case 'gui/main/static/tabs/settings/content/theme': return 'Tema';
        case 'gui/main/static/tabs/settings/content/autostart': return 'TERA Toolbox basladığında otomatik çalıştır';
        case 'gui/main/static/tabs/settings/content/updatelog': return 'Detaylı güncelleme kayıtlarını göster';
        case 'gui/main/static/tabs/settings/content/logtimes': return 'Kayıtlarda zaman damgası göster';
        case 'gui/main/static/tabs/settings/content/noupdate': return 'Mod güncellemelerini kapat';
        case 'gui/main/static/tabs/settings/content/noselfupdate': return 'Kök güncellemeleri kapat';
        case 'gui/main/static/tabs/settings/content/devmode': return 'Geliştirici modunu aktifleştir';
        case 'gui/main/static/tabs/settings/content/noslstags': return 'Sunucu listesindeki etiketleri gizle';
        case 'gui/main/static/tabs/settings/content/noserverautojoin': return 'Otomatik sunucu girişini devre dışı bırak';
        case 'gui/main/static/tabs/settings/content/minimizetotray': return 'Sistem tepsisine küçült';
        case 'gui/main/static/tabs/settings/content/removecounters': return 'Hide counters in server list';
        case 'gui/main/static/tabs/settings/content/cleanstart': return 'Clean log every Tera Toolbox start';

        case 'gui/main/static/tabs/help/title': return 'Yardım mı lazım?';

        case 'gui/main/static/tabs/modsfolder/title': return 'Mod dosyasını göster';

        case 'gui/main/static/tabs/credits/title': return 'Emeği geçenler';
        case 'gui/main/static/tabs/credits/loading': return 'Emeği geçenlerin listesi yükleniyor...';
        case 'gui/main/static/tabs/credits/content': return 'Thanks to<br />SaltyMonkey: Installer/Modern UI stuff<br />Mathicha &amp; Pentagon: Old GUI stuff<br />Foglio: Logo design<br />Meishu: Original Tera-Proxy Core<br />All Toolbox Translators<br />All Mod Developers';

        // tera-client-interface
        case 'tera-client-interface/index/communication-error': return '[ToolBox] İstemci ile iletişime geçerken hata oluştu:';

        case 'tera-client-interface/gpkmanager/symlink-warning-1': return '[ToolBox] UYARI: Görünüşe göre TERA ToolBox veya oyun sembolik köprüleri desteklemeyen';
        case 'tera-client-interface/gpkmanager/symlink-warning-2': return '[ToolBox] UYARI: bir sürücü üzerinde kurulu. (örnek olarak bunun sebebi exFAT/FAT32 kullanan sürücülerdir.)!';
        case 'tera-client-interface/gpkmanager/symlink-warning-3': return '[ToolBox] UYARI: Bunun sonucunda, istemci modlarınız kurulumu yeni dosya kopyaları yaparak gerçekleştirir.';
        case 'tera-client-interface/gpkmanager/symlink-warning-4': return '[ToolBox] UYARI: Bunun istemci başlangıç hızınızı yavaşlatacak ve hard diskinize yük bindirecektir!';
        case 'tera-client-interface/gpkmanager/uninstall-error-1': return '[ToolBox] UYARI: Aşağıdaki istemci mod dosyalarınız kaldırılamıyor';
        case 'tera-client-interface/gpkmanager/uninstall-error-2': return `[ToolBox] UYARI: ${tokens.fullPath}`;
        case 'tera-client-interface/gpkmanager/uninstall-error-3': return '[ToolBox] UYARI: Bu dosyalar oyunu bir sonraki açışınızda silinecektir. Bunun yerine bu dosyaları elle kaldırabilirsiniz.';

        // mod
        case 'mod/prefix-log': return `[${tokens.name}]`;
        case 'mod/prefix-warn': return `[${tokens.name}] UYARI:`;
        case 'mod/prefix-error': return `[${tokens.name}] HATA:`;
        case 'mod/settings-load-error-corrupted-1': return 'Programı son kullandığınızda, uygunsuz bir şekilde kapattınız!';
        case 'mod/settings-load-error-corrupted-2': return `Ve bu "${tokens.name}" adlı modun bozulmasına yol açtı!`;
        case 'mod/settings-load-error-corrupted-3': return 'Bu mod varsayılan ayarlarını yükleyecektir, böylece ihtiyacınıza göre düzenleyebilirsiniz.';
        case 'mod/settings-load-error-corrupted-4': return 'Lütfen programı düzgün kapatmayı unutmayın: Önce oyunu kapatın, ardından TeraToolBoxu X butonuna basarak kapatın!';
        case 'mod/settings-load-error-corrupted-5': return 'TeraToolBox çalışırken bilgisayarınızı kapatmayın!';
        case 'mod/settings-load-error-invalid-format-1': return `Bu mod için geçersiz ayarlar yapılmış "${tokens.name}"!`;
        case 'mod/settings-load-error-invalid-format-2': return 'Ve bu sizin bunu, dosyaları elle düzenlerken yaptığınızı gösteriyor.';
        case 'mod/settings-load-error-invalid-format-3': return 'Lütfen dosyaları elle düzenleyin, veya tekrar kurtarılabilmesi için dosyayı silin.';
        case 'mod/settings-load-error-invalid-format-4': return '------------------------------------------';
        case 'mod/settings-load-error-invalid-format-5': return 'Detaylı hata ayrıntıları';
        case 'mod/settings-load-error-invalid-format-6': return 'Dosyanın bulunduğu tam konum:';
        case 'mod/settings-load-error-invalid-format-7': return `  ${tokens.settingsFile}`;
        case 'mod/settings-load-error-invalid-format-8': return 'Tam hata mesajı:';
        case 'mod/settings-load-error-invalid-format-9': return `  ${tokens.e}`;
        case 'mod/settings-load-error-invalid-format-10': return '------------------------------------------';
        case 'mod/settings-save-error-write': return 'Ayarlar kaydedilemedi! Tam hata mesajı:';
        case 'mod/settings-save-error-stringify': return 'Hatalar sıralanamadı! Tam hata mesajı::';
        case 'mod/settings-migrate-error-load-migrator': return 'Ayar aktarıcısı yüklenemedi! Tam hata mesajı:';
        case 'mod/settings-migrate-error-run-migrator': return 'Ayarlar geçirilirken bir hata meydana geldi! Tam hata mesajı:';
        case 'mod/tera-game-state-not-loaded': return '"tera-game-state" yüklenemediği için, bu mod tam performansla çalışmayabilir.';
        case 'mod/client-install-error-1': return `İstemci parçaları yüklenirken hata oluştu!`;
        case 'mod/client-install-error-2': return `Lütfen Modun sahibiyle iletişime geçin: ${tokens.supportUrl}`;
        
        case 'mod/mod-preloaded': return `[mods] Önyüklenmiş mod ${tokens.name}`;
        case 'mod/mod-preload-error-1': return `[mods] HATA: ${tokens.name} Adlı mod önyüklenemedi!`;
        case 'mod/mod-preload-error-2': return `[mods] HATA: Lütfen Modun sahibiyle iletişime geçin: ${tokens.supportUrl}`;
        case 'mod/mod-unloaded': return `[Modlar] Pasifleştirilmiş mod ${tokens.name}`;
        case 'mod/mod-reloaded': return `[Modlar] Yeniden yüklenen modül ${tokens.name}`;
        
        case 'mod/mod-global-instance-loaded': return `[mods] Başlatılan Mod ${tokens.name}`;
        case 'mod/mod-global-instance-load-error-1': return `[mods] HATA: ${tokens.name} Adlı mod başlatılamadı!`;
        case 'mod/mod-global-instance-load-error-2': return `[mods] HATA: Lütfen Modun sahibiyle iletişime geçin: ${tokens.supportUrl}`;
        case 'mod/mod-global-instance-unloaded': return `[mods] ${tokens.name} Adlı mod durduruldu!`;
        case 'mod/mod-global-instance-unload-error-1': return `[mods] HATA: ${tokens.name} Adlı mod durdurulamadı!`;
        case 'mod/mod-global-instance-unload-error-2': return `[mods] HATA: Lütfen Modun sahibiyle iletişime geçin: ${tokens.supportUrl}`;
        
        case 'mod/mod-client-instance-loaded': return `[mods] ${tokens.name} Adlı mod istemciye bağlandı`;
        case 'mod/mod-client-instance-load-error-1': return `[mods] HATA: ${tokens.name} Adlı mod istemciye bağlanamadı!`;
        case 'mod/mod-client-instance-load-error-2': return `[mods] HATA: Lütfen Modun sahibiyle iletişime geçin: ${tokens.supportUrl}`;
        case 'mod/mod-client-instance-unloaded': return `[mods] ${tokens.name} Adlı modun istemciyle bağlantısı kesildi`;
        case 'mod/mod-client-instance-unload-error-1': return `[mods] HATA: ${tokens.name} Adlı modun istemciyle bağlantısı kesilemedi!`;
        case 'mod/mod-client-instance-unload-error-2': return `[mods] HATA: Lütfen Modun sahibiyle iletişime geçin: ${tokens.supportUrl}`;
        
        case 'mod/mod-network-instance-loaded': return `[mods] ${tokens.name} Adlı mod sunucu bağlantısına entegre edildi`; 
        case 'mod/mod-network-instance-load-error-1': return `[mods] HATA: ${tokens.name} Adlı mod sunucu bağlantısına entegre edilemedi!`;
        case 'mod/mod-network-instance-load-error-2': return `[mods] HATA: Lütfen Modun sahibiyle iletişime geçin: ${tokens.supportUrl}`;
        case 'mod/mod-network-instance-unloaded': return `[mods] ${tokens.name} Adlı modun sunucu bağlantısı kesildi!`;
        case 'mod/mod-network-instance-unload-error-1': return `[mods] HATA: ${tokens.name} Adlı modun sunucu bağlantısı kesilemedi!`;
        case 'mod/mod-network-instance-unload-error-2': return `[mods] HATA: Lütfen Modun sahibiyle iletişime geçin: ${tokens.supportUrl}`;

        // mod-manager
        case 'mod-manager/load-module-info-error': return `[Modlar] HATA: Mod yüklenemedi. Daha fazla bilgi için "${tokens.name}"! Hata metnini tamamı:`;
        case 'mod-manager/duplicate-mod-error': return `[Modlar] HATA: Kopyalanmış mod "${tokens.name}" tespit edildi!`;
        case 'mod-manager/missing-mod-dependency-error': return `[Modlar] HATA: Adlı mod ${tokens.name} adlı dosyaların "${tokens.dependency}" yüklü olmasını gerektiriyor, fakat dosyalar yüklü değil!`;
        case 'mod-manager/mod-conflict-error': return `[Modlar] HATA: Adlı mod ${tokens.name} isimli mod yüklü iken "${tokens.conflict}" aktifleştirilemez!`;
        case 'mod-manager/cannot-load-mod-not-installed': return `[Modlar] HATA: Yüklü olmayan bir mod başlatılmaya çalışıldı: ${tokens.name}`;
        case 'mod-manager/cannot-unload-mod-not-installed': return `[Modlar] HATA: Yüklü olmayan bir mod durdurulmaya çalışıldı: ${tokens.name}`;
        case 'mod-manager/cannot-unload-mod-not-loaded': return `[Modlar] HATA: Aktif olmayan bir mod deaktif hale getirilmeye çalışıldı: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-installed': return `[Modlar] HATA: Yüklü olmayan bir mod  yeniden başlatılmaya çalışıldı: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-supported': return `[Modlar] HATA: Hızlı yeniden yükleme desteklemeyen bir modül yeniden yüklenmeye çalışıldı: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-loaded': return `[Modlar] HATA: Aktifleştirilmemiş bir mod yeniden yuklenmeye çalışıldı: ${tokens.name}`;

        // default
        default: throw new Error(`Invalid string "${str}"!`);
    }
};

module.exports = { Name, GetString };
