// Brazilian Portuguese translation by Box#0069 "BAAAAHX"

const Name = 'Português Brasileiro';

function GetString(str, tokens) {
    switch (str) {
        // connection-manager
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-1': return `[connection] ERRO: Não foi possível conectar com o servidor em ${tokens.address}:${tokens.port} (${tokens.code})! Razões comuns para isso são:`;
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-2': return '[connection] - Uma conexão de Internet instável ou um Ban geográfico de IP';
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-3': return '[connection] - Manutenção dos servidores do jogo';
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-1': return `[connection] ERRO: ${tokens.code} - Conexão com o servidor do jogo foi interrompida inesperadamente. Razões comuns para isso são:`;
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-2': return '[connection] - Uma desconexão causada por una conexão de Internet instável';
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-3': return '[connection] - Um exploit/trapaça ou módulo quebrado que te desconectou';
        case 'connection-manager/connected': return `[connection] routing ${tokens.remote} to ${tokens.remoteAddress}:${tokens.remotePort}`;
        case 'connection-manager/disconnected': return `[connection] ${tokens.remote} disconnected`;

        // loader-cli
        case 'loader-cli/error-node-too-old-1': return 'ERRO: Sua versão de Node.JS é muito antiga para fazer TERA Toolbox funcionar!';
        case 'loader-cli/error-node-too-old-2': return 'ERRO: Por favor, baixe e reinstale TERA Toolbox, ou instale a última versão de Node.JS de https://nodejs.org/en/download/current/';
        case 'loader-cli/error-runtime-incompatible-default': return `ERRO: ${tokens.message}`;
        case 'loader-cli/error-config-corrupt-1': return 'ERRO: Oopa, parece que você fodeu o seu config.json!';
        case 'loader-cli/error-config-corrupt-2': return `ERRO: Tente consertar ou pergunte aqui: ${tokens.supportUrl}`;
        case 'loader-cli/error-migration-failed-1': return 'ERRO: Não foi possível migrar os arquivos desde a versão anterior de TERA Toolbox!';
        case 'loader-cli/error-migration-failed-2': return 'ERRO: Por favor, reinstale uma versão limpa do programa usando o último instalador';
        case 'loader-cli/error-migration-failed-3': return `ERRO: Ou pergunte aqui: ${tokens.supportUrl}`;
        case 'loader-cli/error-cannot-start-proxy': return '[toolbox]  Não foi possível iniciar o proxy de rede, terminando...';
        case 'loader-cli/terminating': return 'terminando...';
        case 'loader-cli/warning-noupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-cli/warning-noupdate-2': return '!!!!!      VOCÊ DESABILITOU AS ATUALIZAÇÕES AUTOMÁTICAS     !!!!!';
        case 'loader-cli/warning-noupdate-3': return '!!!!!       NÃO TERÁ SUPORTE PARA QUALQUER PROBLEMA QUE     !!!!!';
        case 'loader-cli/warning-noupdate-4': return '!!!!!            VOCÊ ENCONTRAR POR TER FEITO ISSO          !!!!!';
        case 'loader-cli/warning-noupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-cli/warning-update-mod-not-supported': return `[update] ATENÇÃO: O módulo ${tokens.name} não suporta atualizações automáticas!`;
        case 'loader-cli/error-update-mod-failed': return `[update] ERRO: O módulo ${tokens.name} não pôde ser atualizado e poderia estar quebrado!`;
        case 'loader-cli/error-update-failed': return 'ERRO: Não foi possível auto atualizar! A mensagem de erro completa é:';

        // loader-gui
        case 'loader-gui/tray/quit': return 'Sair';
        case 'loader-gui/error-config-file-corrupt/title': return 'Arquivo de configurações inválido!';
        case 'loader-gui/error-config-file-corrupt/message': return `O arquivo config.json na sua pasta de TERA Toolbox está malformado. Tente consertar você mesmo, delete-o para gerar um novo, ou pergunte em ${tokens.supportUrl} para receber ajuda!\n\n O programa será terminado agora.`;
        case 'loader-gui/error-migration-failed/title': return 'Erro de migração!';
        case 'loader-gui/error-migration-failed/message': return `Não foi possível migrar arquivos desde uma versão anterior de TERA Toolbox.\nPor favor, reinstale uma versão limpa usando o último instalador ou pergunte em ${tokens.supportUrl} para obter ajuda!\n\nO programa será terminado agora.`;
        case 'loader-gui/error-cannot-start-proxy': return '[toolbox] Não foi possível iniciar o proxy de rede!';
        case 'loader-gui/terminating': return 'terminando...';
        case 'loader-gui/warning-noselfupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noselfupdate-2': return '!!!!!      VOCÊ DESABILITOU AS ATUALIZAÇÕES AUTOMÁTICAS     !!!!!';
        case 'loader-gui/warning-noselfupdate-3': return '!!!!!       NÃO TERÁ SUPORTE PARA QUALQUER PROBLEMA QUE     !!!!!';
        case 'loader-gui/warning-noselfupdate-4': return '!!!!!            VOCÊ ENCONTRAR POR TER FEITO ISSO          !!!!!';
        case 'loader-gui/warning-noselfupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noupdate-2': return '!!!!!      VOCÊ DESABILITOU AS ATUALIZAÇÕES AUTOMÁTICAS     !!!!!';
        case 'loader-gui/warning-noupdate-3': return '!!!!!       NÃO TERÁ SUPORTE PARA QUALQUER PROBLEMA QUE     !!!!!';
        case 'loader-gui/warning-noupdate-4': return '!!!!!            VOCÊ ENCONTRAR POR TER FEITO ISSO          !!!!!';
        case 'loader-gui/warning-noupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-update-mod-not-supported': return `[update] ATENÇÃO: O módulo ${tokens.name} não suporta atualizações automáticas!`;
        case 'loader-gui/error-update-mod-failed': return `[update] ERRO: O módulo ${tokens.name} não pôde ser atualizado e poderia estar quebrado!`;
        case 'loader-gui/error-update-failed': return 'ERRO: Não foi possível auto atualizar! A mensagem de erro completa é:';
        case 'loader-gui/proxy-starting': return '[toolbox] Iniciando o proxy de rede...';
        case 'loader-gui/proxy-stopping': return '[toolbox] Parando o proxy de rede...';
        case 'loader-gui/proxy-stopped': return '[toolbox] O proxy de rede foi parado!';
        case 'loader-gui/mod-installed': return `[toolbox] O módulo "${tokens.name}" foi instalado`;
        case 'loader-gui/mod-uninstalled': return `[toolbox] O módulo "${tokens.name}" foi desinstalado`;
        case 'loader-gui/mod-load-toggled': return `[toolbox] Foi ${tokens.enabled ? 'Ativado' : 'Desativado'} o módulo "${tokens.name}"`;
        case 'loader-gui/mod-updates-toggled': return `[toolbox] Foram ${tokens.updatesEnabled ? 'Ativadas' : 'Desativadas'} as atualizações automáticas para o módulo "${tokens.name}"`;

        // proxy
        case 'proxy/ready': return '[toolbox] Pronto, esperando pelo início do jogo!';
        case 'proxy/client-interface-error': return '[toolbox] ERRO: Não foi possível iniciar o servidor de interface do cliente.';
        case 'proxy/client-interface-error-EADDRINUSE': return '[toolbox] ERRO: Outra instância de TERA Toolbox já está sendo executada. Por favor, feche-a ou reinicie o seu computador e tente novamente!';
        case 'proxy/client-interface-error-EADDRNOTAVAIL': return '[toolbox] ERRO: Endereço não disponível. Reinicie o seu computador e tente novamente!';
        case 'proxy/client-interface-connection-error': return `[toolbox] Não foi possível estabelecer uma conexão com o cliente: ${tokens.error}`;
        case 'proxy/client-interface-connected': return `[toolbox] O cliente ${tokens.justStarted ? 'conectado' : 'reconectado'} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion})`;
        case 'proxy/client-interface-disconnected': return `[toolbox] O cliente foi desconectado.`;
        case 'proxy/redirecting-server': return `[toolbox] Redirecionando ${tokens.name} (${tokens.publisher.toUpperCase()}-${tokens.serverId}) de ${tokens.listen_ip}:${tokens.listen_port} a ${tokens.ip}:${tokens.port}`;
        case 'proxy/warning-unmapped-protocol-1': return `[toolbox] ATENÇÃO: Versão do protocolo não mapeada ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion}).`;
        case 'proxy/warning-unmapped-protocol-2': return '[toolbox] ATENÇÃO: Isso pode ter acontecido por alguma destas razões:';
        case 'proxy/warning-unmapped-protocol-3': return '[toolbox] ATENÇÃO: 1) Você está tentando jogar usando uma versão do cliente nova, que ainda não é suportada.';
        case 'proxy/warning-unmapped-protocol-4': return '[toolbox] ATENÇÃO:    Se o jogo entrou em manutenção recentemente, por favor, reporte isso!';
        case 'proxy/warning-unmapped-protocol-5': return '[toolbox] ATENÇÃO:    Senão, o seu cliente poderia ter sido atualizado para uma versão nova muito cedo.';
        case 'proxy/warning-unmapped-protocol-6': return '[toolbox] ATENÇÃO: 2) Você está tentando jogar usando uma versão do jogo desatualizada.';
        case 'proxy/warning-unmapped-protocol-7': return '[toolbox] ATENÇÃO:    Tente reparar o cliente ou reinstalar o jogo para consertar isto!';
        case 'proxy/warning-unmapped-protocol-8': return `[toolbox] ATENÇÃO: Se você não consegue consertar isso sozinho, peça ajuda aqui: ${tokens.supportUrl}!`;
        case 'proxy/error-cannot-load-protocol': return `ERRO: Não foi possível carregar a versão do protocolo: ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion})!`;
        case 'proxy/protocol-loaded': return `[toolbox] Carregada versão do protocolo: ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion}).`;
        case 'proxy/error-installing-gpks': return 'ERRO: Não é possível instalar mods GPK! A mensagem de erro completa é:';

        // update
        case 'update/started': return '[atualizações] Atualização automática iniciada!';
        case 'update/core-module-initialized': return `[atualizações] Inicializado o módulo central "${tokens.coreModule}"`;
        case 'update/dependency-module-initialized': return `[atualizações] Inicializada a dependência "${tokens.dependency}" para o módulo "${tokens.name}"`;
        case 'update/warning-module-update-disabled': return `[atualizações] ATENÇÃO: Atualizações desativadas para o módulo ${tokens.name}!`;
        case 'update/start-module-install': return `[atualizações] Instalando módulo ${tokens.name}`;
        case 'update/start-module-update': return `[atualizações] Atualizando módulo ${tokens.name}`;
        case 'update/warning-module-no-update-servers': return `[atualizações] ATENÇÃO: O módulo ${tokens.name} não tem nenhum servidor de atualização especificado!`;
        case 'update/module-download-manifest': return `[atualizações] - Recuperando o manifesto de atualização (Server ${tokens.serverIndex})`;
        case 'update/module-download-file': return `[atualizações] - Baixar ${tokens.file}`;
        case 'update/module-config-changed': return '[atualizações] - Configuração do módulo modificada, reiniciando a atualização!';
        case 'update/module-update-failed-1': return `[atualizações] ERRO: Não foi possível atualizar o módulo ${tokens.name}:`;
        case 'update/module-update-failed-2-1': return `[atualizações] Por favor, entre em ${tokens.supportUrl} e siga as instruções, ou peça ajuda.`;
        case 'update/module-update-failed-2-2': return `[atualizações] Alternativamente, pergunte aqui: ${tokens.supportUrl}`;
        case 'update/module-update-failed-3': return `[atualizações] Por favor, contate o autor do módulo ou pergunte aqui: ${tokens.supportUrl}`;
        case 'update/finished': return '[atualizações] Atualização automática finalizada!';

        // gui
        case 'gui/tooltip/download': return 'Download mod';
        case 'gui/tooltip/remove': return 'Remove mod';
        case 'gui/tooltip/toggleMod': return 'Enable/disable mod';
        case 'gui/tooltip/toggleModAutoupdate': return 'Enable/disable mod autoupdate';
        case 'gui/tooltip/donate': return 'Donate to author';
        case 'gui/tooltip/supportLink': return 'Visit mod support page';
        case 'gui/tooltip/readme': return 'Open file with information';

        case 'gui/main/title': return 'TERA Toolbox';
        
        case 'gui/main/start-stop-proxy-running': return 'Parar';
        case 'gui/main/start-stop-proxy-not-running': return 'Iniciar';
        case 'gui/main/start-stop-proxy-starting': return 'Iniciando...';
        case 'gui/main/start-stop-proxy-stopping': return 'Parando...';

        case 'gui/main/status-proxy-running': return 'Rodando';
        case 'gui/main/status-proxy-not-running': return 'Parado';
        case 'gui/main/status-update-available': return 'ATUALIZAÇÃO DISPONÍVEL - POR FAVOR REINICIE TERA TOOLBOX';

        case 'gui/main/modal/buttons/ok': return 'OK';
        case 'gui/main/modal/warn-mod-update-disabled': return 'Atenção! Você desativou as atualizações automáticas para todos os seus módulos. Isso irá criar problemas no futuro. Não iremos prover assistência se não ativar novamente!';
        case 'gui/main/modal/warn-self-update-disabled': return 'Atenção! Você desativou as atualizações automáticas para TERA Toolbox. Isso irá criar problemas no futuro. Não iremos prover assistência se não ativar novamente!';
        case 'gui/main/modal/error-cannot-install-mod-while-running': return 'Você não pode instalar módulos enquanto TERA Toolbox está rodando. Por favor, pare o proxy primeiro!';
        case 'gui/main/modal/error-cannot-uninstall-mod-while-running': return 'Você não pode desinstalar módulos enquanto TERA Toolbox está rodando. Por favor, pare o proxy primeiro!';

        case 'gui/main/static/tabs/log/title': return 'Registro';
        case 'gui/main/static/tabs/log/loading': return 'Carregando o registro do proxy...';

        case 'gui/main/static/tabs/mods/title': return 'Meus Módulos';
        case 'gui/main/static/tabs/mods/loading': return 'Carregando os módulos instalados...';

        case 'gui/main/static/tabs/newmods/title': return 'Mais Módulos';
        case 'gui/main/static/tabs/newmods/loading': return 'Carregando a lista de módulos...';
        case 'gui/main/static/tabs/newmods/content/filter': return 'Filtro: ';
        case 'gui/main/static/tabs/newmods/content/filter/network': return 'Módulos de Rede/Proxy';
        case 'gui/main/static/tabs/newmods/content/filter/client': return 'Modificações do Cliente/Interface';

        case 'gui/main/static/tabs/settings/title': return 'Configurações';
        case 'gui/main/static/tabs/settings/groupclient': return 'Game client:';
        case 'gui/main/static/tabs/settings/toolbox': return 'Tera Toolbox:';
        case 'gui/main/static/tabs/settings/loading': return 'Carregando as configurações...';
        case 'gui/main/static/tabs/settings/content/uilanguage': return 'Idioma';
        case 'gui/main/static/tabs/settings/content/theme': return 'Tema';
        case 'gui/main/static/tabs/settings/content/autostart': return 'Auto-iniciar ao abrir TERA Toolbox';
        case 'gui/main/static/tabs/settings/content/updatelog': return 'Mostrar registro de atualizações detalhado';
        case 'gui/main/static/tabs/settings/content/logtimes': return 'Mostrar tempo no registro';
        case 'gui/main/static/tabs/settings/content/noupdate': return 'Desativar atualizações dos módulos';
        case 'gui/main/static/tabs/settings/content/noselfupdate': return 'Desativar as atualizações de TERA Toolbox';
        case 'gui/main/static/tabs/settings/content/devmode': return 'Ativar modo de desenvolvedor';
        case 'gui/main/static/tabs/settings/content/noslstags': return 'Ocultar etiquetas na lista dos servidores';
        case 'gui/main/static/tabs/settings/content/noserverautojoin': return 'Desativar conexão automática ao servidor';
        case 'gui/main/static/tabs/settings/content/minimizetotray': return 'Minimizar à bandeja do sistema';
        case 'gui/main/static/tabs/settings/content/removecounters': return 'Hide counters in server list';
        case 'gui/main/static/tabs/settings/content/cleanstart': return 'Clean log every Tera Toolbox start';

        case 'gui/main/static/tabs/help/title': return 'Precisa de Ajuda?';

        case 'gui/main/static/tabs/modsfolder/title': return 'Mostrar Pasta de Módulos';

        case 'gui/main/static/tabs/credits/title': return 'Créditos';
        case 'gui/main/static/tabs/credits/loading': return 'Carregando créditos...';
        case 'gui/main/static/tabs/credits/content': return 'Thanks to<br />SaltyMonkey: Installer/Modern UI stuff<br />Mathicha &amp; Pentagon: Old GUI stuff<br />Foglio: Logo design<br />Meishu: Original Tera-Proxy Core<br />All Toolbox Translators<br />All Mod Developers';

        // tera-client-interface
        case 'tera-client-interface/index/communication-error': return '[toolbox] Erro ao comunicar com o cliente:';

        case 'tera-client-interface/gpkmanager/symlink-warning-1': return '[toolbox] ATENÇÃO: Parece que ou TERA Toolbox ou o jogo estão num disco ou partição que';
        case 'tera-client-interface/gpkmanager/symlink-warning-2': return '[toolbox] ATENÇÃO: Não suporta links simbólicos (porque está formatado em exFAT ou FAT32, por exemplo)!';
        case 'tera-client-interface/gpkmanager/symlink-warning-3': return '[toolbox] ATENÇÃO: Nesse caso, os seus mods de cliente serão instalados criando cópias dos arquivos como alternativa.';
        case 'tera-client-interface/gpkmanager/symlink-warning-4': return '[toolbox] ATENÇÃO: Saiba que isso poderia fazer o início do jogo mais lento e colocar mais peso no seu disco!';
        case 'tera-client-interface/gpkmanager/uninstall-error-1': return '[toolbox] ATENÇÃO: Não foi possível remover o seguinte arquivo do mod de cliente:';
        case 'tera-client-interface/gpkmanager/uninstall-error-2': return `[toolbox] ATENÇÃO: ${tokens.fullPath}`;
        case 'tera-client-interface/gpkmanager/uninstall-error-3': return '[toolbox] ATENÇÃO: Será removido a próxima vez que você iniciar o jogo. Você também pode removê-lo manualmente.';

        // mod
        case 'mod/prefix-log': return `[${tokens.name}]`;
        case 'mod/prefix-warn': return `[${tokens.name}] ATENÇÃO:`;
        case 'mod/prefix-error': return `[${tokens.name}] ERRO:`;
        case 'mod/settings-load-error-corrupted-1': return 'Você fechou o programa de maneira imprópria!';
        case 'mod/settings-load-error-corrupted-2': return `Isto fez com que as configurações do módulo "${tokens.name}" tenham se corrompido!`;
        case 'mod/settings-load-error-corrupted-3': return 'O módulo irá carregar as configurações por defeito, ajuste-as de acordo com as suas necessidades.';
        case 'mod/settings-load-error-corrupted-4': return 'Por favor, lembre-se de fechar o programa corretamente: Primeiramente feche o jogo e então feche TERA Toolbox apertando o X!';
        case 'mod/settings-load-error-corrupted-5': return 'Não desligue o computador enquanto TERA Toolbox estiver rodando!';
        case 'mod/settings-load-error-invalid-format-1': return `Formato de configurações inválido para o módulo "${tokens.name}"!`;
        case 'mod/settings-load-error-invalid-format-2': return 'Isto quer dizer que você o quebrou ao editá-lo manualmente.';
        case 'mod/settings-load-error-invalid-format-3': return 'Por favor, conserte o arquivo de configurações manualmente ou apague-o para que as configurações por defeito sejam restauradas.';
        case 'mod/settings-load-error-invalid-format-4': return '------------------------------------------';
        case 'mod/settings-load-error-invalid-format-5': return 'Detalhes avançados do erro';
        case 'mod/settings-load-error-invalid-format-6': return 'A localização do arquivo é:';
        case 'mod/settings-load-error-invalid-format-7': return `  ${tokens.settingsFile}`;
        case 'mod/settings-load-error-invalid-format-8': return 'A mensagem de erro completa é:';
        case 'mod/settings-load-error-invalid-format-9': return `  ${tokens.e}`;
        case 'mod/settings-load-error-invalid-format-10': return '------------------------------------------';
        case 'mod/settings-save-error-write': return 'Não foi possível salvar as configurações! A mensagem de erro completa é:';
        case 'mod/settings-save-error-stringify': return 'Não foi possível serializar as configurações! A mensagem de erro completa é:';
        case 'mod/settings-migrate-error-load-migrator': return 'Não foi possível carregar o migrador de configurações! A mensagem de erro completa é:';
        case 'mod/settings-migrate-error-run-migrator': return 'Um erro ocorreu durante a migração das configurações! A mensagem de erro completa é:';
        case 'mod/tera-game-state-not-loaded': return 'Este mod pode apresentar erros, pois "tera-game-state" não pôde ser carregado.';
        case 'mod/client-install-error-1': return `Um erro ocorreu ao instalar os componentes do cliente!`; 
        case 'mod/client-install-error-2': return `Por favor, contate o autor do módulo: ${tokens.supportUrl}`; 
        
        case 'mod/mod-preloaded': return `[mods] Pré-carregado módulo ${tokens.name}`; 
        case 'mod/mod-preload-error-1': return `[mods] ERRO: O módulo ${tokens.name} não pôde ser pré-carregado!`; 
        case 'mod/mod-preload-error-2': return `[mods] ERRO: Por favor, contate o autor do módulo: ${tokens.supportUrl}`; 
        case 'mod/mod-unloaded': return `[mods] Descarregado o módulo ${tokens.name}`;
        case 'mod/mod-reloaded': return `[mods] Carregado o módulo ${tokens.name}`;
        
        case 'mod/mod-global-instance-loaded': return `[mods] Iniciado módulo ${tokens.name}`; 
        case 'mod/mod-global-instance-load-error-1': return `[mods] ERRO: O módulo ${tokens.name} não pôde ser iniciado!`; 
        case 'mod/mod-global-instance-load-error-2': return `[mods] ERRO: Por favor, contate o autor do módulo: ${tokens.supportUrl}`; 
        case 'mod/mod-global-instance-unloaded': return `[mods] Módulo parado ${tokens.name}`; 
        case 'mod/mod-global-instance-unload-error-1': return `[mods] ERRO: O módulo ${tokens.name} não pôde ser parado!`; 
        case 'mod/mod-global-instance-unload-error-2': return `[mods] ERRO: Por favor, contate o autor do módulo: ${tokens.supportUrl}`; 
        
        case 'mod/mod-client-instance-loaded': return `[mods] Conectado o módulo ${tokens.name} ao cliente`; 
        case 'mod/mod-client-instance-load-error-1': return `[mods] ERRO: O módulo ${tokens.name} não pôde ser conectado ao cliente!`; 
        case 'mod/mod-client-instance-load-error-2': return `[mods] ERRO: Por favor, contate o autor do módulo: ${tokens.supportUrl}`; 
        case 'mod/mod-client-instance-unloaded': return `[mods] Desconectado o módulo ${tokens.name} do cliente`; 
        case 'mod/mod-client-instance-unload-error-1': return `[mods] ERRO: O módulo ${tokens.name} não pôde ser desconectado do cliente!!`; 
        case 'mod/mod-client-instance-unload-error-2': return `[mods] ERRO: Por favor, contate o autor do módulo: ${tokens.supportUrl}`; 
        
        case 'mod/mod-network-instance-loaded': return `[mods] Conectado o módulo ${tokens.name} à conexão do servidor`; 
        case 'mod/mod-network-instance-load-error-1': return `[mods] ERRO: O módulo ${tokens.name} não pôde ser conectado à conexão do servidor!`; 
        case 'mod/mod-network-instance-load-error-2': return `[mods] ERRO: Por favor, contate o autor do módulo: ${tokens.supportUrl}`; 
        case 'mod/mod-network-instance-unloaded': return `[mods] Desconectado o módulo ${tokens.name} da conexão do servidor`; 
        case 'mod/mod-network-instance-unload-error-1': return `[mods] ERRO: O módulo ${tokens.name} não pôde ser desconectado da conexão do servidor!`; 
        case 'mod/mod-network-instance-unload-error-2': return `[mods] ERRO: Por favor, contate o autor do módulo: ${tokens.supportUrl}`; 
        
        // mod-manager
        case 'mod-manager/load-module-info-error': return `[mods] ERRO: Não foi possível carregar a informação do módulo "${tokens.name}"! A mensagem de erro completa é:`;
        case 'mod-manager/duplicate-mod-error': return `[mods] ERRO: Mods múltiplos com o nome "${tokens.name}" detectados!`;
        case 'mod-manager/missing-mod-dependency-error': return `[mods] ERRO: O módulo ${tokens.name} requer "${tokens.dependency}" para funcionar, mas não está instalado!`;
        case 'mod-manager/mod-conflict-error': return `[mods] ERRO: O módulo ${tokens.name} não pode ser carregado enquanto "${tokens.conflict}" estiver instalado!`;
        case 'mod-manager/cannot-load-mod-not-installed': return `[mods] ERRO: Tentando carregar módulo que não está instalado: ${tokens.name}`;
        case 'mod-manager/cannot-unload-mod-not-installed': return `[mods] ERRO: Tentando descarregar módulo que não está instalado: ${tokens.name}`;
        case 'mod-manager/cannot-unload-mod-not-loaded': return `[mods] ERRO: Tentando descarregar módulo que não está carregado: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-installed': return `[mods] ERRO: Tentando recarregar módulo que não está instalado: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-supported': return `[mods] ERRO: Tentando recarregar módulo que não suporta hot-reload: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-loaded': return `[mods] ERRO: Tentando recarregar módulo que não está carregado: ${tokens.name}`;
        
        // default
        default: throw new Error(`Invalid string "${str}"!`);
    }
};

module.exports = { Name, GetString };