// Polish translation by Kaga#1000

const Name = 'Polski';

function GetString(str, tokens) {
    switch (str) {
        // connection-manager
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-1': return `[połączenie] BŁĄD: Wystąpił problem z połączeniem z serwerem gry w ${tokens.address}:${tokens.port} (${tokens.code})! Najczęściej jest to spowodowane:`;
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-2': return '[połączenie] - Niestabilnym połączeniem sieciowym, lub blokadą regionalną (geo-IP ban)';
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-3': return '[połączenie] - Prace serwisowe na serwerach gry';
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-1': return `[połączenie] BŁĄD: ${tokens.code} - Połączenie z serwerem gry zostało niespodziewanie zakończone. Najczęściej jest to spowodowane:`;
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-2': return '[połączenie] - Rozłączeniem spowodowanym niestabilnym połączeniem sieciowym';
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-3': return '[połączenie] - Exploit/cheat lub zepsuty/niezaktualizowany moduł, który spowodował wyrzucenie z gry';
        case 'connection-manager/connected': return `[połączenie] przekierowuję ${tokens.remote} do ${tokens.remoteAddress}:${tokens.remotePort}`;
        case 'connection-manager/disconnected': return `[połączenie] ${tokens.remote} rozłączono`;

        // loader-cli
        case 'loader-cli/error-node-too-old-1': return 'BŁĄD: Twoja obecnie zainstalowana wersja Node.JS jest zbyt stara, aby uruchomić TERA Toolbox!';
        case 'loader-cli/error-node-too-old-2': return 'BŁĄD: Proszę pobrać i zainstalować ponownie TERA Toolbox, lub zainstalować najnowszą wersję Node.JS z https://nodejs.org/en/download/current/';
        case 'loader-cli/error-runtime-incompatible-default': return `BŁĄD: ${tokens.message}`;
        case 'loader-cli/error-config-corrupt-1': return 'BŁĄD: Oops, wygląda na to, że zjebałeś swój config.json!';
        case 'loader-cli/error-config-corrupt-2': return `BŁĄD: Spróbuj naprawić to samodzielnie, lub spytaj o pomoc tutaj: ${tokens.supportUrl}`;
        case 'loader-cli/error-migration-failed-1': return 'BŁĄD: Wystąpił problem z migracją plików ze starej wersji TERA Toolbox!';
        case 'loader-cli/error-migration-failed-2': return 'BŁĄD: Proszę zainstalować czystą kopię używając najnowszego instalatora';
        case 'loader-cli/error-migration-failed-3': return `BŁĄD: lub zapytać o pomoc tutaj: ${tokens.supportUrl}`;
        case 'loader-cli/error-cannot-start-proxy': return '[toolbox] Wystapił problem z uruchomieniem sieciowego proxy, kończę proces...';
        case 'loader-cli/terminating': return 'Kończę proces...';
        case 'loader-cli/warning-noupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-cli/warning-noupdate-2': return '!!!!!    CAŁKOWICIE WYŁĄCZYŁEŚ AUTOMATYCZNE AKTUALIZACJE    !!!!!';
        case 'loader-cli/warning-noupdate-3': return '!!!!!   NIE BĘDZIE ŻADNEGO WSPARCIA, DLA ŻADNEGO PROBLEMU,  !!!!!';
        case 'loader-cli/warning-noupdate-4': return '!!!!!       NA KTÓRY W Z ZWIĄZKU Z TYM SIĘ NATKNIESZ        !!!!!';
        case 'loader-cli/warning-noupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-cli/warning-update-mod-not-supported': return `[aktualizacja] OSTRZEŻENIE: Moduł ${tokens.name} nie posiada wsparcia dla auto-aktualizacji!`;
        case 'loader-cli/error-update-mod-failed': return `[aktualizacja] BŁĄD: Moduł ${tokens.name} nie mógł zostać zaktualizowany i może być popsuty!`;
        case 'loader-cli/error-update-failed': return 'BŁĄD: Wystąpił problem z auto-aktualizacją! Pełny kod błędu to:';

        // loader-gui
        case 'loader-gui/tray/quit': return 'Wyjście';
        case 'loader-gui/error-config-file-corrupt/title': return 'Nieprawidłowy plik konfiguracyjny!';
        case 'loader-gui/error-config-file-corrupt/message': return `Plik config.json w folderze TERA Toolbox jest zjebany. Spróbuj naprawić to samodzielnie, usuń go aby wygenerować nowy, albo spytaj o pomoc tutaj: ${tokens.supportUrl} \n\nProgram zostanie teraz zakończony.`;
        case 'loader-gui/error-migration-failed/title': return 'Błąd migracji!';
        case 'loader-gui/error-migration-failed/message': return `Wystąpił problem z migracją plików ze starej wersji TERA Toolbox.\nProszę zainstalować czystą kopię używając najnowszego instalatora, lub zapytać o pomoc tutaj: ${tokens.supportUrl} \n\nProgram zostanie teraz zakończony.`;
        case 'loader-gui/error-cannot-start-proxy': return '[toolbox] Wystapił problem z uruchomieniem sieciowego proxy!';
        case 'loader-gui/terminating': return 'kończę proces...';
        case 'loader-gui/warning-noselfupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noselfupdate-2': return '!!!!!    CAŁKOWICIE WYŁĄCZYŁEŚ AUTOMATYCZNE AKTUALIZACJE    !!!!!';
        case 'loader-gui/warning-noselfupdate-3': return '!!!!!   NIE BĘDZIE ŻADNEGO WSPARCIA, DLA ŻADNEGO PROBLEMU,  !!!!!';
        case 'loader-gui/warning-noselfupdate-4': return '!!!!!       NA KTÓRY W Z ZWIĄZKU Z TYM SIĘ NATKNIESZ        !!!!!';
        case 'loader-gui/warning-noselfupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noupdate-2': return '!!!!!     CAŁKOWICIE WYŁĄCZYŁEŚ AUTOMATYCZNE AKTUALIZACJE MODUŁÓW     !!!!!';
        case 'loader-gui/warning-noupdate-3': return '!!!!!        NIE BĘDZIE ŻADNEGO WSPARCIA, DLA ŻADNEGO PROBLEMU,       !!!!!';
        case 'loader-gui/warning-noupdate-4': return '!!!!!            NA KTÓRY W Z ZWIĄZKU Z TYM SIĘ NATKNIESZ             !!!!!';
        case 'loader-gui/warning-noupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-update-mod-not-supported': return `[aktualizacja] OSTRZEŻENIE: Moduł ${tokens.name} nie posiada wsparcia dla auto-aktualizacji!`;
        case 'loader-gui/error-update-mod-failed': return `[aktualizacja] BŁĄD: Moduł ${tokens.name} nie mógł zostać zaktualizowany i może być popsuty!`;
        case 'loader-gui/error-update-failed': return 'BŁĄD: Wystąpił problem z auto-aktualizacją! Pełny kod błędu to:';
        case 'loader-gui/proxy-starting': return '[toolbox] Uruchamiam sieciowe proxy...';
        case 'loader-gui/proxy-stopping': return '[toolbox] Zatrzymuję sieciowe proxy...';
        case 'loader-gui/proxy-stopped': return '[toolbox] Sieciowe proxy zatrzymane!';
        case 'loader-gui/mod-installed': return `[toolbox] Zainstalowano "${tokens.name}"`;
        case 'loader-gui/mod-uninstalled': return `[toolbox] Odinstalowano "${tokens.name}"`;
        case 'loader-gui/mod-load-toggled': return `[toolbox] ${tokens.enabled ? 'Włączony' : 'Wyłączony'} "${tokens.name}"`;
        case 'loader-gui/mod-updates-toggled': return `[toolbox] ${tokens.updatesEnabled ? 'Włączono' : 'Wyłączono'} automatyczne aktualizacje dla "${tokens.name}"`;

        // proxy
        case 'proxy/ready': return '[toolbox] Gotowy, czekam na uruchomienie klienta gry!';
        case 'proxy/client-interface-error': return '[toolbox] BŁĄD: Wystąpił problem z uruchomieniem serwera interfejsu klienta.';
        case 'proxy/client-interface-error-EADDRINUSE': return '[toolbox] BŁĄD: Inny proces TERA Toolbox jest nadal uruchomiony. Proszę go zamknąć lub zrestartować komputer i spróbować ponownie!';
        case 'proxy/client-interface-error-EADDRNOTAVAIL': return '[toolbox] BŁĄD: Adres jest niedostępny. Zrestartuj komputer i spróbuj ponownie!';
        case 'proxy/client-interface-connection-error': return `[toolbox] Wystąpił problem z ustanowieniem połączenia z grą: ${tokens.error}`;
        case 'proxy/client-interface-connected': return `[toolbox] Klient ${tokens.justStarted ? 'połączony' : 'połączony ponownie'} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion})`;
        case 'proxy/client-interface-disconnected': return `[toolbox] Klient rozłączony`;
        case 'proxy/redirecting-server': return `[toolbox] Przekierowuję ${tokens.name} (${tokens.publisher.toUpperCase()}-${tokens.serverId}) z ${tokens.listen_ip}:${tokens.listen_port} do ${tokens.ip}:${tokens.port}`;
        case 'proxy/warning-unmapped-protocol-1': return `[toolbox] OSTRZEŻENIE: Niezmapowana wersja protokołu ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion}).`;
        case 'proxy/warning-unmapped-protocol-2': return '[toolbox] OSTRZEŻENIE: Może to być spowodowane przez każdy z przypadków wymienionych niżej:';
        case 'proxy/warning-unmapped-protocol-3': return '[toolbox] OSTRZEŻENIE: 1) Próbujesz zagrać używając nowo wydanej wersji klienta gry, która nie jest jeszcze wspierana.';
        case 'proxy/warning-unmapped-protocol-4': return '[toolbox] OSTRZEŻENIE:    Jeśli w ostatnich godzinach gra była w trakcie prac serwisowych, proszę to zgłosić!';
        case 'proxy/warning-unmapped-protocol-5': return '[toolbox] OSTRZEŻENIE:    Poza tym, twój klient mógł zostać zaktualizowany przedwcześnie w związku z nadchodzącym nowym patchem.';
        case 'proxy/warning-unmapped-protocol-6': return '[toolbox] OSTRZEŻENIE: 2) Próbujesz zagrać używając niezaktualizowanej wersji klienta gry.';
        case 'proxy/warning-unmapped-protocol-7': return '[toolbox] OSTRZEŻENIE:    Spróbuj użyć opcji naprawy plików gry lub zainstalować ją całkowicie od nowa aby to naprawić!';
        case 'proxy/warning-unmapped-protocol-8': return `[toolbox] OSTRZEŻENIE: Jesli nie jesteś w stanie naprawić tego sam, zapytaj o pomoc tutaj: ${tokens.supportUrl}!`;
        case 'proxy/error-cannot-load-protocol': return `BŁĄD: Wystąpił problem z załadowaniem wersji protokołu ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion})!`;
        case 'proxy/protocol-loaded': return `[toolbox] Załadowano wersję protokołu ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion}).`;
        case 'proxy/error-installing-gpks': return 'BŁĄD: Nie można zainstalować modów GPK! Pełny kod błędu:';

        // update
        case 'update/started': return '[aktualizacja] Auto-aktualizacja rozpoczęta!';
        case 'update/core-module-initialized': return `[aktualizacja] Zainicjowano moduł podstawowy "${tokens.coreModule}"`;
        case 'update/dependency-module-initialized': return `[aktualizacja] Zainicjowano zależność "${tokens.dependency}" dla modułu "${tokens.name}"`;
        case 'update/warning-module-update-disabled': return `[aktualizacja] OSTRZEŻENIE: Wyłączono auto-aktualizację dla modułu ${tokens.name}!`;
        case 'update/start-module-install': return `[aktualizacja] Instalacja modułu ${tokens.name}`;
        case 'update/start-module-update': return `[aktualizacja] Aktualizacja modułu ${tokens.name}`;
        case 'update/warning-module-no-update-servers': return `[aktualizacja] OSTRZEŻENIE: Moduł ${tokens.name} nie posiada określonego serwera dla aktualizacji!`;
        case 'update/module-download-manifest': return `[aktualizacja] - Pobieranie manifestu aktualizacji (Serwer ${tokens.serverIndex})`;
        case 'update/module-download-file': return `[aktualizacja] - Pobieranie ${tokens.file}`;
        case 'update/module-config-changed': return '[aktualizacja] - Konfiguracja modułu została zmieniona, restartowanie aktualizacji!';
        case 'update/module-update-failed-1': return `[aktualizacja] BŁĄD: Wystąpił problem z auto-aktualizacją modułu ${tokens.name}:`;
        case 'update/module-update-failed-2-1': return `[aktualizacja] Proszę udać się do ${tokens.supportUrl} oraz zastosować się do podanych instrukcji, albo zapytać o pomoc.`;
        case 'update/module-update-failed-2-2': return `[aktualizacja] Alternatywnie, zapytaj tutaj: ${tokens.supportUrl}`;
        case 'update/module-update-failed-3': return `[aktualizacja] Proszę skontaktować się z autorem modułu, lub zapytać tutaj: ${tokens.supportUrl}`;
        case 'update/finished': return '[aktualizacja] Auto-aktualizacja zakończona!';

        // gui
        case 'gui/tooltip/download': return 'Pobierz';
        case 'gui/tooltip/remove': return 'Usuń';
        case 'gui/tooltip/toggleMod': return 'Włącz/Wyłącz';
        case 'gui/tooltip/toggleModAutoupdate': return 'Włącz/Wyłącz autoaktualizacje';
        case 'gui/tooltip/donate': return 'Wsparcie dla autora';
        case 'gui/tooltip/supportLink': return 'Odwiedź stronę pomocy';
        case 'gui/tooltip/readme': return 'Otwórz plik z informacjami';

        case 'gui/main/title': return 'TERA Toolbox';
        
        case 'gui/main/start-stop-proxy-running': return 'Stop';
        case 'gui/main/start-stop-proxy-not-running': return 'Start';
        case 'gui/main/start-stop-proxy-starting': return 'Startuję...';
        case 'gui/main/start-stop-proxy-stopping': return 'Zatrzymuję...';

        case 'gui/main/status-proxy-running': return 'Uruchomiony';
        case 'gui/main/status-proxy-not-running': return 'Nie uruchomiony';
        case 'gui/main/status-update-available': return 'DOSTĘPNA AKTUALIZACJA - PROSZĘ URUCHOMIĆ PONOWNIE';

        case 'gui/main/modal/buttons/ok': return 'OK';
        case 'gui/main/modal/warn-mod-update-disabled': return 'Ostrzeżenie! Wyłączyłeś/aś automatyczne aktualizacje dla wszystkich Twoich modów. Prędzej czy później spowoduje to problemy, dla których nie zapewnimy wsparcia, dopóki nie włączysz aktualizacji ponownie!';
        case 'gui/main/modal/warn-self-update-disabled': return 'Ostrzeżenie! Wyłączyłeś/aś automatyczne aktualizacje dla TERA Toolbox. Prędzej czy później spowoduje to problemy, dla których nie zapewnimy wsparcia, dopóki nie włączysz aktualizacji ponownie!';
        case 'gui/main/modal/error-cannot-install-mod-while-running': return 'Nie możesz zainstalować modów podczas gdy TERA Toolbox jest uruchomiony. Proszę najpierw go zatrzymać!';
        case 'gui/main/modal/error-cannot-uninstall-mod-while-running': return 'Nie możesz odinstalować modów podczas gdy TERA Toolbox jest uruchomiony. Proszę najpierw go zatrzymać!';

        case 'gui/main/static/tabs/log/title': return 'Log';
        case 'gui/main/static/tabs/log/loading': return 'Ładuję log...';

        case 'gui/main/static/tabs/mods/title': return 'Moje mody';
        case 'gui/main/static/tabs/mods/loading': return 'Ładowanie zainstalowanych modów...';

        case 'gui/main/static/tabs/newmods/title': return 'Więcej modów';
        case 'gui/main/static/tabs/newmods/loading': return 'Ładuję listę modów...';
        case 'gui/main/static/tabs/newmods/content/filter': return 'Filtr: ';
        case 'gui/main/static/tabs/newmods/content/filter/network': return 'Mody sieciowe/proxy';
        case 'gui/main/static/tabs/newmods/content/filter/client': return 'Mody interfejsu/klienta';

        case 'gui/main/static/tabs/settings/title': return 'Ustawienia';
        case 'gui/main/static/tabs/settings/groupclient': return 'Game client:';
        case 'gui/main/static/tabs/settings/toolbox': return 'Tera Toolbox:';
        case 'gui/main/static/tabs/settings/loading': return 'Ładuję ustawienia...';
        case 'gui/main/static/tabs/settings/content/uilanguage': return 'Język';
        case 'gui/main/static/tabs/settings/content/theme': return 'Motyw';
        case 'gui/main/static/tabs/settings/content/autostart': return 'Autostart przy otwieraniu TERA Toolbox';
        case 'gui/main/static/tabs/settings/content/updatelog': return 'Pokaż szczegółowy log aktualizacji';
        case 'gui/main/static/tabs/settings/content/logtimes': return 'Pokaż czas w logu';
        case 'gui/main/static/tabs/settings/content/noupdate': return 'Wyłącz aktualizację modów';
        case 'gui/main/static/tabs/settings/content/noselfupdate': return 'Wyłącz aktualizację programu';
        case 'gui/main/static/tabs/settings/content/devmode': return 'Włącz tryb Dewelopera';
        case 'gui/main/static/tabs/settings/content/noslstags': return 'Ukryj tagi na liście serwerów';
        case 'gui/main/static/tabs/settings/content/noserverautojoin': return 'Wyłącz automatyczne łączenie z serwerem';
        case 'gui/main/static/tabs/settings/content/minimizetotray': return 'Zminimalizuj do zasobnika systemowego';
        case 'gui/main/static/tabs/settings/content/removecounters': return 'Ukryj liczniki na liście serwerów';
        case 'gui/main/static/tabs/settings/content/cleanstart': return 'Wyczyść log po każdym starcie Toolboxa';

        case 'gui/main/static/tabs/help/title': return 'Potrzebna pomoc?';

        case 'gui/main/static/tabs/modsfolder/title': return 'Pokaż folder z modami';

        case 'gui/main/static/tabs/credits/title': return 'Podziękowania';
        case 'gui/main/static/tabs/credits/loading': return 'Ładuję Podzękowania...';
        case 'gui/main/static/tabs/credits/content': return 'Thanks to<br />SaltyMonkey: Installer/Modern UI stuff<br />Mathicha &amp; Pentagon: Old GUI stuff<br />Foglio: Logo design<br />Meishu: Original Tera-Proxy Core<br />All Toolbox Translators<br />All Mod Developers';

        // tera-client-interface
        case 'tera-client-interface/index/communication-error': return '[toolbox] Błąd komunikacji z klientem gry:';

        case 'tera-client-interface/gpkmanager/symlink-warning-1': return '[toolbox] OSTRZEŻENIE: Wygląda na to, że TERA Toolbox lub gra są zlokalizowane na dysku/partycji, która nie wspiera';
        case 'tera-client-interface/gpkmanager/symlink-warning-2': return '[toolbox] OSTRZEŻENIE: dowiązań symbolicznych (przykładowo dlatego, że jest sformatowany przy użyciu systemu exFAT lub FAT32)!';
        case 'tera-client-interface/gpkmanager/symlink-warning-3': return '[toolbox] OSTRZEŻENIE: Jako rozwiązanie zastępczne, Twoje mody klienta zostaną zainstalowane jako kopie plików.';
        case 'tera-client-interface/gpkmanager/symlink-warning-4': return '[toolbox] OSTRZEŻENIE: Pamiętaj, że może to skutkować spowolnieniem uruchamiania klienta gry, oraz większym obciążeniem dysku!';
        case 'tera-client-interface/gpkmanager/uninstall-error-1': return '[toolbox] OSTRZEŻENIE: Wystapił problem przy usuwaniu następującego modu klienta:';
        case 'tera-client-interface/gpkmanager/uninstall-error-2': return `[toolbox] OSTRZEŻENIE: ${tokens.fullPath}`;
        case 'tera-client-interface/gpkmanager/uninstall-error-3': return '[toolbox] OSTRZEŻENIE: Zostanie on usuniętny przy następnym uruchomieniu gry, lub możesz go usunąć ręcznie.';

        // mod
        case 'mod/prefix-log': return `[${tokens.name}]`;
        case 'mod/prefix-warn': return `[${tokens.name}] OSTRZEŻENIE:`;
        case 'mod/prefix-error': return `[${tokens.name}] BŁĄD:`;
        case 'mod/settings-load-error-corrupted-1': return 'Niepoprawnie zamknąłeś/aś program podczas ostatniego jego użytkowania!';
        case 'mod/settings-load-error-corrupted-2': return `Spowodowało to uszkodzenie ustawień dla modułu "${tokens.name}"!`;
        case 'mod/settings-load-error-corrupted-3': return 'Zostaną teraz załadowane domyślne ustawienia dla tego modułu, więc dostosuj je do własnych potrzeb.';
        case 'mod/settings-load-error-corrupted-4': return 'Proszę pamiętaj o poprawnym zamykaniu programu: po pierwsze, primo, zamknij grę; po drugie, primo, zamknij TERA Toolbox używając przycisku X!';
        case 'mod/settings-load-error-corrupted-5': return 'Po trzecie, primo ULTIMO; nie wyłączaj swojego komputera podczas gdy TERA Toolbox jest uruchomiony!';
        case 'mod/settings-load-error-invalid-format-1': return `Niepoprawny format ustawień dla modułu "${tokens.name}"!`;
        case 'mod/settings-load-error-invalid-format-2': return 'Oznacza to, że zepsułeś go przy ręcznym jego edytowaniu.';
        case 'mod/settings-load-error-invalid-format-3': return 'Proszę naprawić plik ustawień manualnie, lub go usunąć aby mogły zostać przywrócone ustawienia domyślne.';
        case 'mod/settings-load-error-invalid-format-4': return '------------------------------------------';
        case 'mod/settings-load-error-invalid-format-5': return 'Zaawansowane szczegóły błędu';
        case 'mod/settings-load-error-invalid-format-6': return 'Pełna ścieżka do pliku:';
        case 'mod/settings-load-error-invalid-format-7': return `  ${tokens.settingsFile}`;
        case 'mod/settings-load-error-invalid-format-8': return 'Pełny kod błędu:';
        case 'mod/settings-load-error-invalid-format-9': return `  ${tokens.e}`;
        case 'mod/settings-load-error-invalid-format-10': return '------------------------------------------';
        case 'mod/settings-save-error-write': return 'Wystąpił problem z zachowaniem ustawień! Pełny kod błędu:';
        case 'mod/settings-save-error-stringify': return 'Wystąpił problem ze zorganizowaniem ustawień! Pełny kod błędu:';
        case 'mod/settings-migrate-error-load-migrator': return 'Wystąpił problem z załadowaniem migratora ustawień! Pełny kod błędu:';
        case 'mod/settings-migrate-error-run-migrator': return 'Wystąpił błąd przy migrowaniu ustawień! Pełny kod błędu::';
        case 'mod/tera-game-state-not-loaded': return 'Ten moduł moze nie działać poprawnie, gdyż "tera-game-state" nie mógł zostać załadowany.';
        case 'mod/client-install-error-1': return `Wystąpił błąd podczas instalacji elementów klienta!`;
        case 'mod/client-install-error-2': return `Proszę skontaktować się z autorem moda: ${tokens.supportUrl}`;
        
        case 'mod/mod-preloaded': return `[mods] Moduł ${tokens.name} został wstępnie załadowany`;
        case 'mod/mod-preload-error-1': return `[mods] BŁĄD: Nie udało się wstępnie załadować modułu ${tokens.name}!`;
        case 'mod/mod-preload-error-2': return `[mods] BŁĄD: Proszę skontaktować się z autorem moda: ${tokens.supportUrl}`;
        case 'mod/mod-unloaded': return `[mods] Wyładowano moduł ${tokens.name}`;
        case 'mod/mod-reloaded': return `[mods] Przeładowano moduł ${tokens.name}`;
        
        case 'mod/mod-global-instance-loaded': return `[mods] Uruchomiono moduł ${tokens.name}`;
        case 'mod/mod-global-instance-load-error-1': return `[mods] BŁĄD: Nie udało się uruchomić modułu ${tokens.name}!`;
        case 'mod/mod-global-instance-load-error-2': return `[mods] BŁĄD: Proszę skontaktować się z autorem moda: ${tokens.supportUrl}`;
        case 'mod/mod-global-instance-unloaded': return `[mods] Zatrzymano moduł ${tokens.name}`;
        case 'mod/mod-global-instance-unload-error-1': return `[mods] BŁĄD: Nie udało się zatrzymać modułu ${tokens.name}!`;
       case 'mod/mod-global-instance-unload-error-2': return `[mods] BŁĄD: Proszę skontaktować się z autorem moda: ${tokens.supportUrl}`;
        
        case 'mod/mod-client-instance-loaded': return `[mods] Połączono moduł ${tokens.name} z klientem`;
        case 'mod/mod-client-instance-load-error-1': return `[mods] BŁĄD: Nie udało się połączyć modułu ${tokens.name} z klientem!`;
        case 'mod/mod-client-instance-load-error-2': return `[mods] BŁĄD: Proszę skontaktować się z autorem moda: ${tokens.supportUrl}`;
        case 'mod/mod-client-instance-unloaded': return `[mods] Rozłączono moduł ${tokens.name} od klienta`;
        case 'mod/mod-client-instance-unload-error-1': return `[mods] BŁĄD: Nie udało się rozłączyć modułu ${tokens.name} od klienta!`;
        case 'mod/mod-client-instance-unload-error-2': return `[mods] BŁĄD: Proszę skontaktować się z autorem moda: ${tokens.supportUrl}`;
        
        case 'mod/mod-network-instance-loaded': return `[mods] Moduł ${tokens.name} został podpięty do połączenia serwera`;
        case 'mod/mod-network-instance-load-error-1': return `[mods] BŁĄD: Nie udało się podpiąć modułu ${tokens.name} do połączenia serwera!`;
        case 'mod/mod-network-instance-load-error-2': return `[mods] BŁĄD: Proszę skontaktować się z autorem moda: ${tokens.supportUrl}`;
        case 'mod/mod-network-instance-unloaded': return `[mods] Odpięto moduł ${tokens.name} od połączenia serwera`;
        case 'mod/mod-network-instance-unload-error-1': return `[mods] BŁĄD: Nie udało się odpiąć modułu ${tokens.name} od połączenia serwera!`;
        case 'mod/mod-network-instance-unload-error-2': return `[mods] BŁĄD: Proszę skontaktować się z autorem moda: ${tokens.supportUrl}`;

        // mod-manager
        case 'mod-manager/load-module-info-error': return `[mods] BŁĄD: Wystąpił problem przy ładowaniu informacji o module "${tokens.name}"! Pełny kod błędu:`;
        case 'mod-manager/duplicate-mod-error': return `[mods] BŁĄD: Wykryto duplikat modułu "${tokens.name}"!`;
        case 'mod-manager/missing-mod-dependency-error': return `[mods] BŁĄD: Moduł ${tokens.name} wymaga zainstalowania "${tokens.dependency}", którego brakuje!`;
        case 'mod-manager/mod-conflict-error': return `[mods] BŁĄD: Moduł ${tokens.name} nie może zostać załadowany, podczas gdy "${tokens.conflict}" jest zainstalowany!`;
        case 'mod-manager/cannot-load-mod-not-installed': return `[mods] BŁĄD: Próba załadowania modułu, który nie jest zainstalowany: ${tokens.name}`;
        case 'mod-manager/cannot-unload-mod-not-installed': return `[mods] BŁĄD: Próba wyładowania modułu, który nie jest zainstalowany: ${tokens.name}`;
        case 'mod-manager/cannot-unload-mod-not-loaded': return `[mods] BŁĄD: Próba wyładowania modułu, który nie jest załadowany: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-installed': return `[mods] BŁĄD: Próba przeładowania modułu, który nie jest zainstalowany: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-supported': return `[mods] BŁĄD: Próba przeładowania modułu, który nie obsługuje szybkiego przeładowania (hot-reload): ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-loaded': return `[mods] BŁĄD: Próba przeładowania modułu, który nie jest załadowany: ${tokens.name}`;

        // default
        default: throw new Error(`Invalid string "${str}"!`);
    }
};

module.exports = { Name, GetString };