// Italian translation by Foglio#1024

const Name = 'Italiano';

function GetString(str, tokens) {
    switch (str) {
        // connection-manager
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-1': return `[connection] ERRORE: Impossibile connettersi al server di gioco all'indirizzo ${tokens.address}:${tokens.port} (${tokens.code})! Alcune possibili cause possono essere:`;
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-2': return '[connection] - Una connessione instabile o un ban IP geografico';
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-3': return '[connection] - Manutenzione dei server di gioco';
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-1': return `[connection] ERRORE: ${tokens.code} - Connessione al server di gioco terminata inaspettatamente. Alcuni possibili cause possono essere:`;
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-2': return '[connection] - Una disconnessione causata da una connessione internet instabile';
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-3': return '[connection] - Un exploit/cheat o mod difettoso che ti ha fatto disconnettere forzatamente';
        case 'connection-manager/connected': return `[connection] reindirizzamento di ${tokens.remote} a ${tokens.remoteAddress}:${tokens.remotePort}`;
        case 'connection-manager/disconnected': return `[connection] ${tokens.remote} disconnesso`;

        // loader-cli
        case 'loader-cli/error-node-too-old-1': return 'ERRORE: La versione di node.js è troppo vecchia per eseguire TERA Toolbox!';
        case 'loader-cli/error-node-too-old-2': return 'ERRORE: Riscarica e reinstalla TERA Toolbox, o installa l\'ultima versione di node.js da https://nodejs.org/en/download/current/';
        case 'loader-cli/error-runtime-incompatible-default': return `ERRORE: ${tokens.message}`;
        case 'loader-cli/error-config-corrupt-1': return 'ERRORE: Oops, sembra che tu abbia commesso errori in config.json!';
        case 'loader-cli/error-config-corrupt-2': return `ERRORE: Prova a correggerlo o chiedi qui: ${tokens.supportUrl}`;
        case 'loader-cli/error-migration-failed-1': return 'ERRORE: Impossibile migrare file da una versione precedente di TERA Toolbox!';
        case 'loader-cli/error-migration-failed-2': return 'ERRORE: Reinstalla utilizzando l\'installer più recente';
        case 'loader-cli/error-migration-failed-3': return `ERRORE: o chiedi aiuto qui: ${tokens.supportUrl}`;
        case 'loader-cli/error-cannot-start-proxy': return '[toolbox] Impossibile avviare il proxy di rete, arresto...';
        case 'loader-cli/terminating': return 'arresto...';
        case 'loader-cli/warning-noupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-cli/warning-noupdate-2': return '!!!!!     HAI DISATTIVATO GLI AGGIORNAMENTI AUTOMATICI      !!!!!';
        case 'loader-cli/warning-noupdate-3': return '!!!!!  NON CI SARÀ NESSUN SUPPORTO PER QUALSIASI PROBLEMA   !!!!!';
        case 'loader-cli/warning-noupdate-4': return '!!!!!      CHE POTRESTI INCONTRARE PER AVER FATTO CIÒ       !!!!!';
        case 'loader-cli/warning-noupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-cli/warning-update-mod-not-supported': return `[update] ATTENZIONE: Il modulo ${tokens.name} non supporta l\'aggiornamento automatico!`;
        case 'loader-cli/error-update-mod-failed': return `[update] ERRORE: Non è stato possibile aggiornare il modulo ${tokens.name} che potrebbe non funzionare!`;
        case 'loader-cli/error-update-failed': return 'ERRORE: Impossibile effettuare l\'aggiornamento automatico! Messaggio di errore completo:';

        // loader-gui
        case 'loader-gui/tray/quit': return 'Esci';
        case 'loader-gui/error-config-file-corrupt/title': return 'File di impostazioni non valido!';
        case 'loader-gui/error-config-file-corrupt/message': return `Il file config.json nella tua cartella di TERA Toolbox non è valido. Prova a correggerlo, o a cancellarlo per generarne uno nuovo, o chiedi aiuto in ${tokens.supportUrl}!\n\nIl programma sarà terminato.`;
        case 'loader-gui/error-migration-failed/title': return 'Errore di migrazione!';
        case 'loader-gui/error-migration-failed/message': return `Impossibile migrare file da una versione precedente di TERA Toolbox.\nReinstalla utilizzando l'ultimo installer o chiedi aiuto in ${tokens.supportUrl}!\n\nIl programma sarà terminato.`;
        case 'loader-gui/error-cannot-start-proxy': return '[toolbox] Impossibile avviare il proxy di rete!';
        case 'loader-gui/terminating': return 'arresto...';
        case 'loader-gui/warning-noselfupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noselfupdate-2': return '!!!!!       HAI DISATTIVATO GLI AGGIORNAMENTI AUTOMATICI DI TERA TOOLBOX       !!!!!';
        case 'loader-gui/warning-noselfupdate-3': return '!!!!!           NON CI SARÀ NESSUN SUPPORTO PER QUALSIASI PROBLEMA             !!!!!';
        case 'loader-gui/warning-noselfupdate-4': return '!!!!!               CHE POTRESTI INCONTRARE PER AVER FATTO CIÒ                 !!!!!';
        case 'loader-gui/warning-noselfupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noupdate-1':return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noupdate-2':return '!!!!!     HAI DISATTIVATO GLI AGGIORNAMENTI AUTOMATICI       !!!!!';
        case 'loader-gui/warning-noupdate-3':return '!!!!!  NON CI SARÀ NESSUN SUPPORTO PER QUALSIASI PROBLEMA    !!!!!';
        case 'loader-gui/warning-noupdate-4':return '!!!!!      CHE POTRESTI INCONTRARE PER AVER FATTO CIÒ        !!!!!';
        case 'loader-gui/warning-noupdate-5':return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-update-mod-not-supported': return `[update] ATTENZIONE: Il modulo ${tokens.name} non supporta l'aggiornamento automatico!`;
        case 'loader-gui/error-update-mod-failed': return `[update] ERRORE: Non è stato possibile aggiornare il modulo ${tokens.name} che potrebbe non funzionare!`;
        case 'loader-gui/error-update-failed': return 'ERRORE: Impossibile effettuare l\'aggiornamento automatico! Messaggio di errore completo:';
        case 'loader-gui/proxy-starting': return '[toolbox] Avvio del proxy di rete...';
        case 'loader-gui/proxy-stopping': return '[toolbox] Arresto del proxy di rete...';
        case 'loader-gui/proxy-stopped': return '[toolbox] Proxy di rete arrestato!';
        case 'loader-gui/mod-installed': return `[toolbox] Modulo "${tokens.name}" installato`;
        case 'loader-gui/mod-uninstalled': return `[toolbox] Modulo "${tokens.name}" disinstallato`;
        case 'loader-gui/mod-load-toggled': return `[toolbox] ${tokens.enabled ? 'Attivato' : 'Disattivato'} "${tokens.name}"`;
        case 'loader-gui/mod-updates-toggled': return `[toolbox] ${tokens.updatesEnabled ? 'Attivati' : 'Disattivati'} gli aggiornamenti automatici per il modulo "${tokens.name}"`;

        // proxy
        case 'proxy/ready': return '[toolbox] Pronto, in attesa dell\'avvio del client di gioco!';
        case 'proxy/client-interface-error': return '[toolbox] ERRORE: Impossibile avviare il server per l\'interfaccia client.';
        case 'proxy/client-interface-error-EADDRINUSE': return '[toolbox] ERRORE: Un\'altra istanza di TERA Toolbox è già in esecuzione. Chiudila o riavvia il computer e riprova!';
        case 'proxy/client-interface-error-EADDRNOTAVAIL': return '[toolbox] ERRORE: Indirizzo non disponibile. Riavvia il computer e riprova!';
        case 'proxy/client-interface-connection-error': return `[toolbox] Impossibile stabilire una connessione con il client: ${tokens.error}`;
        case 'proxy/client-interface-connected': return `[toolbox] Client ${tokens.justStarted ? 'connesso' : 'riconnesso'} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion})`;
        case 'proxy/client-interface-disconnected': return `[toolbox] Client disconnesso`;
        case 'proxy/redirecting-server': return `[toolbox] Reindirizzamento di ${tokens.name} (${tokens.publisher.toUpperCase()}-${tokens.serverId}) da ${tokens.listen_ip}:${tokens.listen_port} a ${tokens.ip}:${tokens.port}`;
        case 'proxy/warning-unmapped-protocol-1': return `[toolbox] ATTENZIONE: Versione del protocollo non mappata ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion}).`;
        case 'proxy/warning-unmapped-protocol-2': return '[toolbox] ATTENZIONE: Ciò può essere causato da:';
        case 'proxy/warning-unmapped-protocol-3': return '[toolbox] ATTENZIONE: 1) Stai cercando di giocare usando una versione del client appena rilasciata e che non è ancora supportata.';
        case 'proxy/warning-unmapped-protocol-4': return '[toolbox] ATTENZIONE:    Se c\'è stata manutenzione nelle ultime ore segnalacelo!';
        case 'proxy/warning-unmapped-protocol-5': return '[toolbox] ATTENZIONE:    Altrimenti, il tuo client potrebbe essersi aggiornato ad una nuova versione troppo presto.';
        case 'proxy/warning-unmapped-protocol-6': return '[toolbox] ATTENZIONE: 2) Stai cercando di giocare usando una versione del client obsoleta.';
        case 'proxy/warning-unmapped-protocol-7': return '[toolbox] ATTENZIONE:    Prova ad effettuare un repair del client o a reinstallare il gioco!';
        case 'proxy/warning-unmapped-protocol-8': return `[toolbox] ATTENZIONE: Se non riesci a risolvere, chiedi aiuto qui: ${tokens.supportUrl}!`;
        case 'proxy/error-cannot-load-protocol': return `ERRORE: Impossibile caricare la versione del protocollo ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion})!`;
        case 'proxy/protocol-loaded': return `[toolbox] Caricata versione del protocollo ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion}).`;
        case 'proxy/error-installing-gpks': return 'ERRORE: Impossible installare il mod GPK! Il messaggio di errore completo è:';

        // update
        case 'update/started': return '[update] Aggiornamento iniziato!';
        case 'update/core-module-initialized': return `[update] Inizializzato modulo core: "${tokens.coreModule}"`;
        case 'update/dependency-module-initialized': return `[update] Inizializzata dipendenza "${tokens.dependency}" per il modulo "${tokens.name}"`;
        case 'update/warning-module-update-disabled': return `[update] ATTENZIONE: Aggiornamento automatico disattivato per il modulo ${tokens.name}!`;
        case 'update/start-module-install': return `[update] Installazione del modulo ${tokens.name}`;
        case 'update/start-module-update': return `[update] Aggiornamento del modulo ${tokens.name}`;
        case 'update/warning-module-no-update-servers': return `[update] ATTENZIONE: Nessun server di aggiornamento specificato per il modulo ${tokens.name}!`;
        case 'update/module-download-manifest': return `[update] - Download del manifesto di aggiornamento (Server ${tokens.serverIndex})`;
        case 'update/module-download-file': return `[update] - Download ${tokens.file}`;
        case 'update/module-config-changed': return '[update] - Configurazione del modulo modificata, riavvio dell\'aggiornamento!';
        case 'update/module-update-failed-1': return `[update] ERRORE: Impossibile aggiornare il modulo ${tokens.name}:`;
        case 'update/module-update-failed-2-1': return `[update] Visita ${tokens.supportUrl} e segui le istruzioni o chiedi aiuto.`;
        case 'update/module-update-failed-2-2': return `[update] In alternativa, chiedi qui: ${tokens.supportUrl}`;
        case 'update/module-update-failed-3': return `[update] Contatta l\'autore del modulo o chiedi qui: ${tokens.supportUrl}`;
        case 'update/finished': return '[update] Aggiornamento completato!';

        // gui

        case 'gui/tooltip/download': return 'Scarica';
        case 'gui/tooltip/remove': return 'Rimuovi';
        case 'gui/tooltip/toggleMod': return 'Attiva/disattiva';
        case 'gui/tooltip/toggleModAutoupdate': return 'Attiva/disattiva auto-aggiornamento';
        case 'gui/tooltip/donate': return "Supporta l'autore";
        case 'gui/tooltip/supportLink': return 'Apri pagina di supporto';
        case 'gui/tooltip/readme': return 'Apri file di informazioni';

        case 'gui/main/title': return 'TERA Toolbox';
        
        case 'gui/main/start-stop-proxy-running': return 'Arresta';
        case 'gui/main/start-stop-proxy-not-running': return 'Avvia';
        case 'gui/main/start-stop-proxy-starting': return 'In avvio...';
        case 'gui/main/start-stop-proxy-stopping': return 'In arresto...';

        case 'gui/main/status-proxy-running': return 'In esecuzione';
        case 'gui/main/status-proxy-not-running': return 'Arrestato';
        case 'gui/main/status-update-available': return 'AGGIORNAMENTO DISPONIBILE - RIAVVIA';

        case 'gui/main/modal/buttons/ok': return 'OK';
        case 'gui/main/modal/warn-mod-update-disabled': return 'Attenzione! Hai disattivato gli aggiornamenti automatici di tutti i tuoi mod. Questo causerà problemi in futuro. Non forniremo alcuna assistenza a meno che non li riabiliti!';
        case 'gui/main/modal/warn-self-update-disabled': return 'Attenzione! Hai disattivato gli aggiornamenti automatici di TERA Toolbox. Questo causerà problemi in futuro.  Non forniremo alcuna assistenza a meno che non li riabiliti!';
        case 'gui/main/modal/error-cannot-install-mod-while-running': return 'Non puoi installare mod mentre TERA Toolbox è in esecuzione. Arrestalo prima!';
        case 'gui/main/modal/error-cannot-uninstall-mod-while-running': return 'Non puoi disinstallare mod mentre TERA Toolbox è in esecuzione. Arrestalo prima!';

        case 'gui/main/static/tabs/log/title': return 'Log';
        case 'gui/main/static/tabs/log/loading': return 'Caricamento log...';

        case 'gui/main/static/tabs/mods/title': return 'Mod installati';
        case 'gui/main/static/tabs/mods/loading': return 'Caricamento mod installati...';

        case 'gui/main/static/tabs/newmods/title': return 'Altri mod';
        case 'gui/main/static/tabs/newmods/loading': return 'Caricamento lista mod...';
        case 'gui/main/static/tabs/newmods/content/filter': return 'Filtro: ';
        case 'gui/main/static/tabs/newmods/content/filter/network': return 'Mod rete/proxy';
        case 'gui/main/static/tabs/newmods/content/filter/client': return 'Mod client/interfaccia';

        case 'gui/main/static/tabs/settings/title': return 'Impostazioni';
        case 'gui/main/static/tabs/settings/groupclient': return 'Game client:';
        case 'gui/main/static/tabs/settings/toolbox': return 'Tera Toolbox:';
        case 'gui/main/static/tabs/settings/loading': return 'Caricamento impostazioni...';
        case 'gui/main/static/tabs/settings/content/uilanguage': return 'Lingua';
        case 'gui/main/static/tabs/settings/content/theme': return 'Tema';
        case 'gui/main/static/tabs/settings/content/autostart': return 'Avvio automatico all\'apertura';
        case 'gui/main/static/tabs/settings/content/updatelog': return 'Mostra dettagli di update';
        case 'gui/main/static/tabs/settings/content/logtimes': return 'Mostra ora nel log';
        case 'gui/main/static/tabs/settings/content/noupdate': return 'Disattiva aggiornamento dei mod';
        case 'gui/main/static/tabs/settings/content/noselfupdate': return 'Disattiva auto-aggiornamento';
        case 'gui/main/static/tabs/settings/content/devmode': return 'Modalità sviluppatore';
        case 'gui/main/static/tabs/settings/content/noslstags': return 'Nascondi tag (Proxy) nella lista dei server';
        case 'gui/main/static/tabs/settings/content/noserverautojoin': return 'Disattiva login automatico al server';
        case 'gui/main/static/tabs/settings/content/minimizetotray': return 'Minimizza nell\'area di notifica';
        case 'gui/main/static/tabs/settings/content/removecounters': return 'Nascondi il numero dei pg nella lista dei server';
        case 'gui/main/static/tabs/settings/content/cleanstart': return 'Cancella log ad ogni avvio di Toolbox';

        case 'gui/main/static/tabs/help/title': return 'Aiuto';

        case 'gui/main/static/tabs/modsfolder/title': return 'Apri cartella mod';

        case 'gui/main/static/tabs/credits/title': return 'Riconoscimenti';
        case 'gui/main/static/tabs/credits/loading': return 'Caricamento riconoscimenti...';
        case 'gui/main/static/tabs/credits/content': return 'Thanks to<br />SaltyMonkey: Installer/Modern UI stuff<br />Mathicha &amp; Pentagon: Old GUI stuff<br />Foglio: Logo design<br />Meishu: Original Tera-Proxy Core<br />All Toolbox Translators<br />All Mod Developers';

        // tera-client-interface
        case 'tera-client-interface/index/communication-error': return '[toolbox] Errore nella comunicazione con il client:';

        case 'tera-client-interface/gpkmanager/symlink-warning-1': return '[toolbox] ATTENZIONE: Sembra che TERA Toolbox o il gioco si trovino in un disco / partizione che non';
        case 'tera-client-interface/gpkmanager/symlink-warning-2': return '[toolbox] ATTENZIONE: supporta link simbolici (per esempio perché formattati in exFAT o FAT32)!';
        case 'tera-client-interface/gpkmanager/symlink-warning-3': return '[toolbox] ATTENZIONE: Come alternativa, i mod di tipo client saranno installati creando copie dei file.';
        case 'tera-client-interface/gpkmanager/symlink-warning-4': return '[toolbox] ATTENZIONE: Considera che ciò potrebbe rallentare l\'avvio del client e mettere sotto stress il tuo disco!';
        case 'tera-client-interface/gpkmanager/uninstall-error-1': return '[toolbox] ATTENZIONE: Impossibile rimuovere il seguente file di client mod:';
        case 'tera-client-interface/gpkmanager/uninstall-error-2': return `[toolbox] ATTENZIONE: ${tokens.fullPath}`;
        case 'tera-client-interface/gpkmanager/uninstall-error-3': return '[toolbox] ATTENZIONE: Sarà cancellato al prossimo avvio del gioco. Puoi anche cancellarlo manualmente.';

        // mod
        case 'mod/prefix-log': return `[${tokens.name}]`;
        case 'mod/prefix-warn': return `[${tokens.name}] ATTENZIONE:`;
        case 'mod/prefix-error': return `[${tokens.name}] ERRORE:`;
        case 'mod/settings-load-error-corrupted-1': return 'Hai chiuso il programma impropriamente l\'ultima volta!';
        case 'mod/settings-load-error-corrupted-2': return `Questo ha corrotto le impostazioni del modulo "${tokens.name}"!`;
        case 'mod/settings-load-error-corrupted-3': return 'Il modulo sarà ora caricato con le impostazioni di default, quindi reimpostalo in base alle tue preferenze.';
        case 'mod/settings-load-error-corrupted-4': return 'Ricorda di chiudere il programma in maniera appropriata: prima chiudi il gioco, poi TERA Toolbox usando la X!';
        case 'mod/settings-load-error-corrupted-5': return 'Non spegnere il computer mentre TERA Toolbox è in esecuzione!';
        case 'mod/settings-load-error-invalid-format-1': return `Formato delle impostazioni non valido per il modulo "${tokens.name}"!`;
        case 'mod/settings-load-error-invalid-format-2': return 'Ciò vuol dire che l\'hai probabilmente danneggiato mentre lo modificavi manualmente.';
        case 'mod/settings-load-error-invalid-format-3': return 'Correggi il file di impostazioni manualmente o cancellalo per ripristinare le impostazioni di default.';
        case 'mod/settings-load-error-invalid-format-4': return '------------------------------------------';
        case 'mod/settings-load-error-invalid-format-5': return 'Dettagli errore:';
        case 'mod/settings-load-error-invalid-format-6': return 'Percorso del file:';
        case 'mod/settings-load-error-invalid-format-7': return `  ${tokens.settingsFile}`;
        case 'mod/settings-load-error-invalid-format-8': return 'Errore completo:';
        case 'mod/settings-load-error-invalid-format-9': return `  ${tokens.e}`;
        case 'mod/settings-load-error-invalid-format-10': return '------------------------------------------';
        case 'mod/settings-save-error-write': return 'Impossibile salvare le impostazioni! L\'errore completo è:';
        case 'mod/settings-save-error-stringify': return 'Impossibile serializzare le impostazioni! L\'errore completo è:';
        case 'mod/settings-migrate-error-load-migrator': return 'Impossibile caricare il migratore di impostazioni! L\'errore completo è:';
        case 'mod/settings-migrate-error-run-migrator': return 'Si è verificato un errore durante la migrazione delle impostazioni! L\'errore completo è:';
        case 'mod/tera-game-state-not-loaded': return 'Questo mod potrebbe non funzionare correttamente perché non è stato possibile caricare "tera-game-state".';
        case 'mod/client-install-error-1': return `Si è verificato un errore durante l\'installazione di alcune componenti client!`;
        case 'mod/client-install-error-2': return `Contatta l\'autore del modulo: ${tokens.supportUrl}`;
        
        case 'mod/mod-preloaded': return `[mods] Modulo precaricato ${tokens.name}`;
        case 'mod/mod-preload-error-1': return `[mods] ERRORE: Impossibile precaricare il modulo ${tokens.name}!`;
        case 'mod/mod-preload-error-2': return `[mods] ERRORE: Contatta l\'autore del modulo: ${tokens.supportUrl}`;
        case 'mod/mod-unloaded': return `[mods] Modulo scaricato: ${tokens.name}`;
        case 'mod/mod-reloaded': return `[mods] Modulo ricaricato: ${tokens.name}`;
        
        case 'mod/mod-global-instance-loaded': return `[mods] Modulo ${tokens.name} avviato`;
        case 'mod/mod-global-instance-load-error-1': return `[mods] ERRORE: Impossibile avviare il modulo ${tokens.name}!`;
        case 'mod/mod-global-instance-load-error-2': return `[mods] ERRORE: Contatta l\'autore del modulo: ${tokens.supportUrl}`;
        case 'mod/mod-global-instance-unloaded': return `[mods] Modulo ${tokens.name} arrestato`;
        case 'mod/mod-global-instance-unload-error-1': return `[mods] ERRORE: Impossibile arrestare il modulo ${tokens.name}!`;
        case 'mod/mod-global-instance-unload-error-2': return `[mods] ERRORE: Contatta l\'autore del modulo: ${tokens.supportUrl}`;
        
        case 'mod/mod-client-instance-loaded': return `[mods] Il modulo ${tokens.name} è stato connesso al client`;
        case 'mod/mod-client-instance-load-error-1': return `[mods] ERRORE: Non è stato possibile connettere il modulo ${tokens.name} al client!`;
        case 'mod/mod-client-instance-load-error-2': return `[mods] ERRORE: Contatta l\'autore del modulo: ${tokens.supportUrl}`;
        case 'mod/mod-client-instance-unloaded': return `[mods] Il modulo ${tokens.name} è stato disconnesso dal client`;
        case 'mod/mod-client-instance-unload-error-1': return `[mods] ERRORE: Impossibile disconnettere il modulo ${tokens.name} dal client!`;
        case 'mod/mod-client-instance-unload-error-2': return `[mods] ERRORE: Contatta l\'autore del modulo: ${tokens.supportUrl}`;
        
        case 'mod/mod-network-instance-loaded': return `[mods] Modulo ${tokens.name} applicato alla connessione di rete`;
        case 'mod/mod-network-instance-load-error-1': return `[mods] ERRORE: Impossibile applicare il modulo ${tokens.name} alla connessione di rete!`;
        case 'mod/mod-network-instance-load-error-2': return `[mods] ERRORE: Contatta l\'autore del modulo: ${tokens.supportUrl}`;
        case 'mod/mod-network-instance-unloaded': return `[mods] Modulo ${tokens.name} rimosso dalla connessione di rete`;
        case 'mod/mod-network-instance-unload-error-1': return `[mods] ERRORE: Impossibile rimuovere il modulo ${tokens.name} dalla connessione di rete!`;
        case 'mod/mod-network-instance-unload-error-2': return `[mods] ERRORE: Contatta l\'autore del modulo: ${tokens.supportUrl}`;

        // mod-manager
        case 'mod-manager/load-module-info-error': return `[mods] ERRORE: Impossibile caricare le informazioni del modulo "${tokens.name}"! L\'errore completo è:`;
        case 'mod-manager/duplicate-mod-error': return `[mods] ERRORE: Rilevato modulo duplicato "${tokens.name}"!`;
        case 'mod-manager/missing-mod-dependency-error': return `[mods] ERRORE: Il modulo ${tokens.name} richiede che "${tokens.dependency}" sia installato, ma non lo è!`;
        case 'mod-manager/mod-conflict-error': return `[mods] Il modulo ${tokens.name} non può essere caricato mentre "${tokens.conflict}" è installato!`;
        case 'mod-manager/cannot-load-mod-not-installed': return `[mods] ERRORE: Tentativo caricare un modulo non installato: ${tokens.name}`;
        case 'mod-manager/cannot-unload-mod-not-installed': return `[mods] ERRORE: Tentativo di scaricare un modulo non installato: ${tokens.name}`;
        case 'mod-manager/cannot-unload-mod-not-loaded': return `[mods] ERRORE: Tentativo di scaricare un modulo non caricato: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-installed': return `[mods] ERRORE: Tentativo di ricaricare un modulo non installato: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-supported': return `[mods] ERRORE: Tentativo di ricaricare un modulo che non supporta hot-reload: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-loaded': return `[mods] ERRORE: Tentativo di ricaricare un modulo non caricato: ${tokens.name}`;

        // default
        default: throw new Error(`Invalid string "${str}"!`);
    }
};

module.exports = { Name, GetString };