﻿// Spanish translation by Ban#5823 and Nihil#3505, fixes by Kaede#1130

const Name = 'Español';

function GetString(str, tokens) {
    switch (str) {
        // connection-manager
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-1': return `[connection] ERROR: Imposible conectarse al servidor del juego en ${tokens.address}:${tokens.port} (${tokens.code})! Los motivos comunes de esto pueden ser:`;
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-2': return '[connection] - Una conección de internet inestable o un IP ban';
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-3': return '[connection] - Servidor del juego en mantenimiento';
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-1': return `[connection] ERROR: ${tokens.code} - La conección con el servidor del juego fue cerrada de manera inesperada. Los motivos comunes de esto pueden ser:`;
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-2': return '[connection] - Desconección a causa de una conección a internet inestable';
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-3': return '[connection] - Algún módulo de exploit o trampa ha hecho que se cierre el juego';
        case 'connection-manager/connected': return `[connection] ruteando de ${tokens.remote} a ${tokens.remoteAddress}:${tokens.remotePort}`;
        case 'connection-manager/disconnected': return `[connection] ${tokens.remote} desconectado`; 

        // loader-cli
        case 'loader-cli/error-node-too-old-1': return 'ERROR: Tu versión instalada de Node.js es muy vieja y/o incompatible con TERA Toolbox!';
        case 'loader-cli/error-node-too-old-2': return 'ERROR: Por favor, descarga e instala TERA Toolbox nuevamente o instala la ultima versión de Node.js en https://nodejs.org/en/download/current/';
        case 'loader-cli/error-runtime-incompatible-default': return `ERROR: ${tokens.message}`;
        case 'loader-cli/error-config-corrupt-1': return 'ERROR: Whoops, parece que jodiste tu config.json!';
        case 'loader-cli/error-config-corrupt-2': return `ERROR: Intenta arreglarlo tu mismo o pregunta aquí: ${tokens.supportUrl}`;
        case 'loader-cli/error-migration-failed-1': return 'ERROR: No se pudieron migrar los archivos de una versión anterior de TERA Toolbox!';
        case 'loader-cli/error-migration-failed-2': return 'ERROR: Por favor re-instala una copia nueva utilizando el ultimo instalador';
        case 'loader-cli/error-migration-failed-3': return `ERROR: o solicita ayuda aquí: ${tokens.supportUrl}`;
        case 'loader-cli/error-cannot-start-proxy': return '[toolbox] Imposible iniciar la conexión proxy, cerrando programa...';
        case 'loader-cli/terminating': return 'cerrando programa...';
        case 'loader-cli/warning-noupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-cli/warning-noupdate-2': return '!!!!! HAS APAGADO LAS ACTUALIZACIONES AUTOMÁTICAS GLOBALES  !!!!!';
        case 'loader-cli/warning-noupdate-3': return '!!!!!  NO HAY SOPORTE POR CUALQUIER CLASE DE PROBLEMA QUE   !!!!!';
        case 'loader-cli/warning-noupdate-4': return '!!!!!          TE PUEDAS ENCONTRAR A RAÍZ DE ESO            !!!!!';
        case 'loader-cli/warning-noupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-cli/warning-update-mod-not-supported': return `[update] ATENCIÓN: El módulo ${tokens.name} no permite actualizaciones automáticas!`;
        case 'loader-cli/error-update-mod-failed': return `[update] ERROR: El módulo ${tokens.name} no pudo ser actualizado y puede estar roto!`;
        case 'loader-cli/error-update-failed': return 'ERROR: Imposible auto-actualizar! El mensaje de error completo es:';

        // loader-gui
        case 'loader-gui/tray/quit': return 'Salir';
        case 'loader-gui/error-config-file-corrupt/title': return 'Archivo de configuración invalido!';
        case 'loader-gui/error-config-file-corrupt/message': return `El archivo config.json en tu carpeta de TERA Toolbox está corrupto. Intenta arreglarlo tu mismo, borrarlo para generar uno nuevo o pregunta en ${tokens.supportUrl} para recibir ayuda!\n\nEl programa se cerrara ahora.`;
        case 'loader-gui/error-migration-failed/title': return 'Error de migración!';
        case 'loader-gui/error-migration-failed/message': return `Unable to migrate files from an old version of TERA Toolbox.\nPlease reinstall a clean copy using the latest installer or ask in ${tokens.supportUrl} for help!\n\nThe program will now be terminated.`;
        case 'loader-gui/error-cannot-start-proxy': return '[toolbox] Imposible iniciar la conexión proxy!';
        case 'loader-gui/terminating': return 'Cerrando...';
        case 'loader-gui/warning-noselfupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noselfupdate-2': return '!!!!!  HAS APAGADO LAS ACTUALIZACIONES PROPIAS AUTOMÁTICAS  !!!!!';
        case 'loader-gui/warning-noselfupdate-3': return '!!!!!  NO HAY SOPORTE POR CUALQUIER CLASE DE PROBLEMA QUE   !!!!!';
        case 'loader-gui/warning-noselfupdate-4': return '!!!!!          TE PUEDAS ENCONTRAR A RAÍZ DE ESO            !!!!!';
        case 'loader-gui/warning-noselfupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noupdate-2': return '!!!!!  HAS APAGADO LAS ACTUALIZACIONES AUTOMÁTICAS GLOBALES !!!!!';
        case 'loader-gui/warning-noupdate-3': return '!!!!!  NO HAY SOPORTE POR CUALQUIER CLASE DE PROBLEMA QUE   !!!!!';
        case 'loader-gui/warning-noupdate-4': return '!!!!!          TE PUEDAS ENCONTRAR A RAÍZ DE ESO            !!!!!';
        case 'loader-gui/warning-noupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-update-mod-not-supported': return `[update] ATENCION: El módulo ${tokens.name} no permite actualizaciones automáticas!`;
        case 'loader-gui/error-update-mod-failed': return `[update] ERROR: El módulo ${tokens.name} no pudo ser actualizado y puede estar roto!`;
        case 'loader-gui/error-update-failed': return 'ERROR: Imcapaz de auto-actualizar! El mensaje de error completo es:';
        case 'loader-gui/proxy-starting': return '[toolbox] Iniciando la conexión proxy...';
        case 'loader-gui/proxy-stopping': return '[toolbox] Deteniendo la conexión proxy...';
        case 'loader-gui/proxy-stopped': return '[toolbox] La conexión proxy se ha detenido!';
        case 'loader-gui/mod-installed': return `[toolbox] Se ha instalado "${tokens.name}"`;
        case 'loader-gui/mod-uninstalled': return `[toolbox] Se ha desinstalado "${tokens.name}"`;
        case 'loader-gui/mod-load-toggled': return `[toolbox] ${tokens.enabled ? 'Habilitado' : 'Deshabilitado'} "${tokens.name}"`;
        case 'loader-gui/mod-updates-toggled': return `[toolbox] ${tokens.updatesEnabled ? 'Habilitado' : 'Deshabilitado'} las actualizaciones automaticas para "${tokens.name}"`;

        // proxy
        case 'proxy/ready': return '[toolbox] Listo, esperando el inicio del cliente!';
        case 'proxy/client-interface-error': return '[toolbox] ERROR: Imposible iniciar la interfaz del servidor.';
        case 'proxy/client-interface-error-EADDRINUSE': return '[toolbox] ERROR: TERA Toolbox ya se está ejecutando en el sistema. Por favor cierrala o reinicia tu PC e intenta de nuevo!';
        case 'proxy/client-interface-error-EADDRNOTAVAIL': return '[toolbox] ERROR: Dirección no disponible. Reinicia tu PC e intenta de nuevo!';
        case 'proxy/client-interface-connection-error': return `[toolbox] Imposible establecer conexión al cliente: ${tokens.error}`;
        case 'proxy/client-interface-connected': return `[toolbox] cliente ${tokens.justStarted ? 'conectado' : 're-conectado'} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion})`;
        case 'proxy/client-interface-disconnected': return `[toolbox] Cliente desconectado`;
        case 'proxy/redirecting-server': return `[toolbox] Redireccionando ${tokens.name} (${tokens.publisher.toUpperCase()}-${tokens.serverId}) desde ${tokens.listen_ip}:${tokens.listen_port} a ${tokens.ip}:${tokens.port}`;
        case 'proxy/warning-unmapped-protocol-1': return `[toolbox] ATENCIÓN: Versión del protocolo sin mapear ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion}).`;
        case 'proxy/warning-unmapped-protocol-2': return '[toolbox] ATENCIÓN: Esto puede ser a causa de lo siguiente:';
        case 'proxy/warning-unmapped-protocol-3': return '[toolbox] ATENCIÓN: 1) Estas intentanto jugar utilizando una versión de cliente nueva que aun no tiene soporte.';
        case 'proxy/warning-unmapped-protocol-4': return '[toolbox] ATENCIÓN:    Si el juego estuvo bajo mantenimiento en las ultimas horas, por favor reportalo!';
        case 'proxy/warning-unmapped-protocol-5': return '[toolbox] ATENCIÓN:    De no ser asi, tu cliente puede haber sido actualizado para una versión futura demaciado temprano.';
        case 'proxy/warning-unmapped-protocol-6': return '[toolbox] ATENCIÓN: 2) Estas intentando jugar utilizando un cliente viejo.';
        case 'proxy/warning-unmapped-protocol-7': return '[toolbox] ATENCIÓN:    Intenta una reparacion de cliente o reinstala el juego entero para arreglar esto!';
        case 'proxy/warning-unmapped-protocol-8': return `[toolbox] ATENCIÓN: Si no puedes arreglar esto por tus propios medios, solicita ayuda aquí: ${tokens.supportUrl}!`;
        case 'proxy/error-cannot-load-protocol': return `ERROR: Imposible cargar la versión del protocolo ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion})!`;
        case 'proxy/protocol-loaded': return `[toolbox] Versión del protocolo cargada: ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion}).`;
        case 'proxy/error-installing-gpks': return 'ERROR: No es posible instalar los mods GPK! El mensaje de error completo es:';

        // update
        case 'update/started': return '[update] Actualización automática iniciada!';
        case 'update/core-module-initialized': return `[update] Iniciando módulo principal "${tokens.coreModule}"`;
        case 'update/dependency-module-initialized': return `[update] Iniciando dependencia "${tokens.dependency}" para el módulo "${tokens.name}"`;
        case 'update/warning-module-update-disabled': return `[update] ATENCIÓN: La actualización automática se ha desactivado para el módulo ${tokens.name}!`;
        case 'update/start-module-install': return `[update] Instalando módulo ${tokens.name}`;
        case 'update/start-module-update': return `[update] Actualizando el módulo ${tokens.name}`;
        case 'update/warning-module-no-update-servers': return `[update] ATENCIÓN: El módulo ${tokens.name} no tiene servidores de actualización especificados!`;
        case 'update/module-download-manifest': return `[update] - Obteniendo manifesto de actualización (Server ${tokens.serverIndex})`;
        case 'update/module-download-file': return `[update] - Descarga ${tokens.file}`;
        case 'update/module-config-changed': return '[update] - Configuración de módulo cambiada, reiniciando actualización!';
        case 'update/module-update-failed-1': return `[update] ERROR: Imposible actualizar automáticamente el módulo ${tokens.name}:`;
        case 'update/module-update-failed-2-1': return `[update] Por favor dirígete a ${tokens.supportUrl} y sigue las instrucciones o solicita ayuda.`;
        case 'update/module-update-failed-2-2': return `[update] Alternativamente, pregunta aqui: ${tokens.supportUrl}`;
        case 'update/module-update-failed-3': return `[update] Por favor contacta al creador del módulo o pregunta aqui: ${tokens.supportUrl}`;
        case 'update/finished': return '[update] Actualizacion automatica completada!';

        // gui

        case 'gui/tooltip/download': return 'Descargar';
        case 'gui/tooltip/remove': return 'Desinstalar';
        case 'gui/tooltip/toggleMod': return 'Habilitar/Deshabilitar';
        case 'gui/tooltip/toggleModAutoupdate': return 'Habilitar/Deshabilitar actualizacion automatica';
        case 'gui/tooltip/donate': return 'Donar al autor';
        case 'gui/tooltip/supportLink': return 'Visitar la pagina de soporte';
        case 'gui/tooltip/readme': return 'Abrir el archivo con información.';
        
        case 'gui/main/title': return 'TERA Toolbox';
        
        case 'gui/main/start-stop-proxy-running': return 'Detener';
        case 'gui/main/start-stop-proxy-not-running': return 'Iniciar';
        case 'gui/main/start-stop-proxy-starting': return 'Iniciando...';
        case 'gui/main/start-stop-proxy-stopping': return 'Deteniendo...';

        case 'gui/main/status-proxy-running': return 'En ejecición';
        case 'gui/main/status-proxy-not-running': return 'En espera';
        case 'gui/main/status-update-available': return 'ACTUALIZACIÓN DISPONIBLE - POR FAVOR REINICIAR';

        case 'gui/main/modal/buttons/ok': return 'OK';
        case 'gui/main/modal/warn-mod-update-disabled': return 'Atención! Has desactivado las actualizaciones automáticas para todos tus módulos. Esto traerá problemas eventualmente. No proveeremos ayuda hasta re-activar esta función!';
        case 'gui/main/modal/warn-self-update-disabled': return 'Atención! Has desactivado las actualizaciones automáticas para TERA Toolbox. Esto traerá problemas eventualmente. No proveeremos ayuda hasta re-activar esta función!';
        case 'gui/main/modal/error-cannot-install-mod-while-running': return 'No puedes instalar módulos mientras TERA Toolbox esta funcionando, por favor detenlo para continuar!';
        case 'gui/main/modal/error-cannot-uninstall-mod-while-running': return 'No puedes desinstalar módulos mientras TERA Toolbox esta funcionando, por favor detenlo para continuar!';

        case 'gui/main/static/tabs/log/title': return 'Registro';
        case 'gui/main/static/tabs/log/loading': return 'Cargando el historial del proxy...';

        case 'gui/main/static/tabs/mods/title': return 'Mis Mods';
        case 'gui/main/static/tabs/mods/loading': return 'Cargando los mods instalados...';

        case 'gui/main/static/tabs/newmods/title': return 'Obtener más mods';
        case 'gui/main/static/tabs/newmods/loading': return 'Cargando la lista de mods...';
        case 'gui/main/static/tabs/newmods/content/filter': return 'Filtro: ';
        case 'gui/main/static/tabs/newmods/content/filter/network': return 'Mods de Red / Proxy';
        case 'gui/main/static/tabs/newmods/content/filter/client': return 'Mods de Cliente / Interfaz';

        case 'gui/main/static/tabs/settings/title': return 'Configuración';
        case 'gui/main/static/tabs/settings/groupclient': return 'Game client:';
        case 'gui/main/static/tabs/settings/toolbox': return 'Tera Toolbox:';
        case 'gui/main/static/tabs/settings/loading': return 'Cargando la configuración...';
        case 'gui/main/static/tabs/settings/content/uilanguage': return 'Idioma';
        case 'gui/main/static/tabs/settings/content/theme': return 'Tema';
        case 'gui/main/static/tabs/settings/content/autostart': return 'Iniciar automaticamente al abrir TERA Toolbox';
        case 'gui/main/static/tabs/settings/content/updatelog': return 'Mostrar registro de actualización detallado';
        case 'gui/main/static/tabs/settings/content/logtimes': return 'Mostrar tiempo en el registro';
        case 'gui/main/static/tabs/settings/content/noupdate': return 'Desactivar la actualización de mods';
        case 'gui/main/static/tabs/settings/content/noselfupdate': return 'Desactivar las actualizaciones de TERA Toolbox';
        case 'gui/main/static/tabs/settings/content/devmode': return 'Habilitar el modo de desarrollador';
        case 'gui/main/static/tabs/settings/content/noslstags': return 'Esconder las etiquetas (proxy) de los servidores';
        case 'gui/main/static/tabs/settings/content/noserverautojoin': return 'Desactivar conexion automatica al servidor';
        case 'gui/main/static/tabs/settings/content/minimizetotray': return 'Minimizar a la bandeja del sistema';
        case 'gui/main/static/tabs/settings/content/removecounters': return 'Esconder contadores en el listado de servidores';
        case 'gui/main/static/tabs/settings/content/cleanstart': return 'Limpiar el registro cada vez que se inicia Tera Toolbox ';

        case 'gui/main/static/tabs/help/title': return 'Ayuda';

        case 'gui/main/static/tabs/modsfolder/title': return 'Abrir carpeta de Mods';

        case 'gui/main/static/tabs/credits/title': return 'Creditos';
        case 'gui/main/static/tabs/credits/loading': return 'Cargando creditos...';
        case 'gui/main/static/tabs/credits/content': return 'Thanks to<br />SaltyMonkey: Installer/Modern UI stuff<br />Mathicha &amp; Pentagon: Old GUI stuff<br />Foglio: Logo design<br />Meishu: Original Tera-Proxy Core<br />All Toolbox Translators<br />All Mod Developers';

        // tera-client-interface
        case 'tera-client-interface/index/communication-error': return '[toolbox] Error al comunicandose con el cliente:';

        case 'tera-client-interface/gpkmanager/symlink-warning-1': return '[toolbox] ATENCIÓN: Parece que TERA Toolbox o el juego están ubicados en un disco / particion que';
        case 'tera-client-interface/gpkmanager/symlink-warning-2': return '[toolbox] ATENCIÓN: no admite enlaces simbólicos (por ejemplo porque está formateado utilizando exFAT o FAT32)!';
        case 'tera-client-interface/gpkmanager/symlink-warning-3': return '[toolbox] ATENCIÓN: Como medida preventiva, las modificaciones del cliente serán instaladas creando copias de los archivos en vez del método convencional.';
        case 'tera-client-interface/gpkmanager/symlink-warning-4': return '[toolbox] ATENCIÓN: Ten en cuenta que esto puede reducir la velocidad de inicio del cliente y generar estrés en tu disco!';
        case 'tera-client-interface/gpkmanager/uninstall-error-1': return '[toolbox] ATENCIÓN: Imposible de remover la siguiente modificación del cliente:';
        case 'tera-client-interface/gpkmanager/uninstall-error-2': return `[toolbox] ATENCIÓN: ${tokens.fullPath}`;
        case 'tera-client-interface/gpkmanager/uninstall-error-3': return '[toolbox] ATENCIÓN: Debido a esto, será eliminado la próxima vez que inicies el juego. También puedes eliminarlo manualmente.';

        // mod
        case 'mod/prefix-log': return `[${tokens.name}]`;
        case 'mod/prefix-warn': return `[${tokens.name}] ATENCION:`;
        case 'mod/prefix-error': return `[${tokens.name}] ERROR:`;
        case 'mod/settings-load-error-corrupted-1': return 'Cerraste el programa de manera inadecuada la ultima vez que lo utilizaste!';
        case 'mod/settings-load-error-corrupted-2': return `Esto llevo a que la configuración del módulo "${tokens.name}" se corrompiera!`;
        case 'mod/settings-load-error-corrupted-3': return 'El módulo cargara con su configuración por defecto, ajustala de acuerdo a tus necesidades nuevamente..';
        case 'mod/settings-load-error-corrupted-4': return 'Por favor recuerda cerrar el programa de manera correcta: primero cierra el juego, luego cierra TERA Toolbox utilizando el botón X!';
        case 'mod/settings-load-error-corrupted-5': return 'No apagues tu PC cuando TERA Toolbox se esté ejecutanmdo!';
        case 'mod/settings-load-error-invalid-format-1': return `Formato de configuración invalido para el módulo "${tokens.name}"!`;
        case 'mod/settings-load-error-invalid-format-2': return 'Esto significa que lo corrompiste cuando lo editaste manualmente.';
        case 'mod/settings-load-error-invalid-format-3': return 'Por favor arregla la configuración del archivo manualmente o borralo para restaurar la configuración por defecto.';
        case 'mod/settings-load-error-invalid-format-4': return '------------------------------------------';
        case 'mod/settings-load-error-invalid-format-5': return 'Detalles avanzados del error';
        case 'mod/settings-load-error-invalid-format-6': return 'La ruta completa de archivo es:';
        case 'mod/settings-load-error-invalid-format-7': return `  ${tokens.settingsFile}`;
        case 'mod/settings-load-error-invalid-format-8': return 'El mensaje de error completo es:';
        case 'mod/settings-load-error-invalid-format-9': return `  ${tokens.e}`;
        case 'mod/settings-load-error-invalid-format-10': return '------------------------------------------';
        case 'mod/settings-save-error-write': return 'Imposible de guardar la configuración! El mensaje de error completo es:';
        case 'mod/settings-save-error-stringify': return 'Imposible de serializar la configuración! El mensaje de error completo es:';
        case 'mod/settings-migrate-error-load-migrator': return 'Imposible de cargar el migrador de configuraciones! El mensaje de error completo es:';
        case 'mod/settings-migrate-error-run-migrator': return 'Ocurrio un error al migrar la configuración! El mensaje de error completo es:';
        case 'mod/tera-game-state-not-loaded': return 'Este mod puede fallar, ya que "tera-game-state" no pudo ser cargado.';
        case 'mod/client-install-error-1': return `Ocurrio un error al instalar los componentes del cliente!`; 
        case 'mod/client-install-error-2': return `Contactate con el autor del modulo: ${tokens.supportUrl}`; 
        
        case 'mod/mod-preloaded': return `[mods] Modulo Precargado: ${tokens.name}`; 
		
        case 'mod/mod-preload-error-1': return `[mods] ERROR: El modulo ${tokens.name} no pudo ser precargado!`; 
        case 'mod/mod-preload-error-2': return `[mods] ERROR: Contactate con el autor del modulo: ${tokens.supportUrl}`; 
        case 'mod/mod-unloaded': return `[mods] Módulo detenido: ${tokens.name}`;
        case 'mod/mod-reloaded': return `[mods] Re-cargando el módulo ${tokens.name}`;
        
        case 'mod/mod-global-instance-loaded': return `[mods] Modulo iniciado: ${tokens.name}`; 
        case 'mod/mod-global-instance-load-error-1': return `[mods] ERROR: El modulo ${tokens.name} no se pudo iniciar!`; 
        case 'mod/mod-global-instance-load-error-2': return `[mods] ERROR: Contactate con el autor del modulo: ${tokens.supportUrl}`; 
        case 'mod/mod-global-instance-unloaded': return `[mods] Modulo detenido: ${tokens.name}`; 
        case 'mod/mod-global-instance-unload-error-1': return `[mods] ERROR: El modulo ${tokens.name} no pudo ser detenido!`; 
        case 'mod/mod-global-instance-unload-error-2': return `[mods] ERROR: Contactate con el autor del modulo: ${tokens.supportUrl}`; 
        
        case 'mod/mod-client-instance-loaded': return `[mods] El modulo ${tokens.name} se ha conectado al cliente`; 
        case 'mod/mod-client-instance-load-error-1': return `[mods] ERROR: El modulo ${tokens.name} no pudo conectarse al cliente!`; 
        case 'mod/mod-client-instance-load-error-2': return `[mods] ERROR: Contactate con el autor del modulo: ${tokens.supportUrl}`; 
        case 'mod/mod-client-instance-unloaded': return `[mods] El modulo ${tokens.name} fue desconectado del cliente`; 
        case 'mod/mod-client-instance-unload-error-1': return `[mods] ERROR: El modulo ${tokens.name} no pudo ser desconectado del cliente!`; 
        case 'mod/mod-client-instance-unload-error-2': return `[mods] ERROR: Contactate con el autor del modulo: ${tokens.supportUrl}`; 
        
        case 'mod/mod-network-instance-loaded': return `[mods] El modulo ${tokens.name} ha aplicado su componente de red al servidor`; // FIXED
        case 'mod/mod-network-instance-load-error-1': return `[mods] ERROR: El modulo ${tokens.name} no pudo aplicar su componente de red al servidor!`; // FIXED
        case 'mod/mod-network-instance-load-error-2': return `[mods] ERROR: Contactate con el autor del modulo:: ${tokens.supportUrl}`; 
        case 'mod/mod-network-instance-unloaded': return `[mods] El modulo ${tokens.name} ha removido su componente de red del servidor`; // FIXED
        case 'mod/mod-network-instance-unload-error-1': return `[mods] ERROR: El modulo ${tokens.name} no pudo remover su componente de red del servidor!`; // FIXED
        case 'mod/mod-network-instance-unload-error-2': return `[mods] ERROR: Contactate con el autor del modulo: ${tokens.supportUrl}`; 

        // mod-manager
        case 'mod-manager/load-module-info-error': return `[mods] ERROR: Imposible cargar la configuración del módulo de "${tokens.name}"! El mensaje de error completo es:`;
        case 'mod-manager/duplicate-mod-error': return `[mods] ERROR: El módulo: "${tokens.name}" está actualmente duplicado!`;
        case 'mod-manager/missing-mod-dependency-error': return `[mods] ERROR: El módulo ${tokens.name} requiere "${tokens.dependency}" para ser instalado!`;
        case 'mod-manager/mod-conflict-error': return `[mods] ERROR: El módulo ${tokens.name} no puede ser cargado mientras "${tokens.conflict}" se encuentre instalado!`;
        case 'mod-manager/cannot-load-mod-not-installed': return `[mods] ERROR: Intentando cargar el siguiente módulo que no está instalado: ${tokens.name}`;
        case 'mod-manager/cannot-unload-mod-not-installed': return `[mods] ERROR: Intentando detener el siguiente módulo que no está instalado: ${tokens.name}`;
        case 'mod-manager/cannot-unload-mod-not-loaded': return `[mods] ERROR: Intentando detener un módulo que no está activo: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-installed': return `[mods] ERROR: tratando de recargar módulo que no se instalo: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-supported': return `[mods] ERROR:tratando de recargar módulo que no se instalo en caliente: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-loaded': return `[mods] ERROR: recargando módulos que no se cargaron: ${tokens.name}`;

        // default
        default: throw new Error(`Invalid string "${str}"!`);
    }
};

module.exports = { Name, GetString };