// German translation by Shalltearz#6717

const Name = 'Deutsch';

function GetString(str, tokens) {
    switch (str) {
        // connection-manager
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-1': return `[Verbindung] FEHLER: Verbindung zum Spiel-Server unter ${tokens.address}:${tokens.port} (${tokens.code}) nicht möglich! Häufige Gründe hierfür sind:`;
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-2': return '[Verbindung] - Eine instabile Internetverbindung oder eine regionale IP-Sperre';
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-3': return '[Verbindung] - Wartung des Spiel-Servers';
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-1': return `[Verbindung] FEHLER: ${tokens.code} - Die Verbindung zum Spiel-Server wurde unerwartet geschlossen. Häufige Gründe hierfür sind:`;
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-2': return '[Verbindung] - Eine Unterbrechung aufgrund einer instabilen Internetverbindung';
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-3': return '[Verbindung] - Ein Exploit / Cheat oder beschädigtes Modul, welches zum Kick geführt hat.';
        case 'connection-manager/connected': return `[Verbindung] Umleitung von ${tokens.remote} zu ${tokens.remoteAddress}:${tokens.remotePort}`;
        case 'connection-manager/disconnected': return `[Verbindung] ${tokens.remote} getrennt`;

        // loader-cli
        case 'loader-cli/error-node-too-old-1': return 'FEHLER: Deine installierte Version von Node.js ist zu alt, um TERA Toolbox auszuführen!';
        case 'loader-cli/error-node-too-old-2': return 'FEHLER: Bitte downloade und installiere TERA Toolbox erneut, oder installiere die neueste Version von Node.js mit dem folgenden Link https://nodejs.org/en/download/current/';
        case 'loader-cli/error-runtime-incompatible-default': return `FEHLER: ${tokens.message}`;
        case 'loader-cli/error-config-corrupt-1': return 'FEHLER: Whoops, es sieht so aus als wäre deine config.json Datei beschädigt!';
        case 'loader-cli/error-config-corrupt-2': return `FEHLER: Versuche den Fehler selbst zu beheben oder bitte hier um Hilfe: ${tokens.supportUrl}`;
        case 'loader-cli/error-migration-failed-1': return 'FEHLER: Dateien einer veralteten Version von TERA Toolbox konnten nicht migriert werden!';
        case 'loader-cli/error-migration-failed-2': return 'FEHLER: Installiere eine saubere Kopie mit dem neuesten Installationsprogramm';
        case 'loader-cli/error-migration-failed-3': return `FEHLER: Oder bitte hier um Hilfe: ${tokens.supportUrl}`;
        case 'loader-cli/error-cannot-start-proxy': return '[Toolbox] Der Netzwerk-Proxy kann nicht gestartet werden!';
        case 'loader-cli/terminating': return 'Programm wird beendet...';
        case 'loader-cli/warning-noupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-cli/warning-noupdate-2': return '!!!!!  DU HAST AUTOMATISCHE MODUL-AKTUALISIERUNGEN DEAKTIVIERT   !!!!!';
        case 'loader-cli/warning-noupdate-3': return '!!!!!          ES GIBT KEINE UNTERSTÜTZUNG FÜR PROBLEME          !!!!!';
        case 'loader-cli/warning-noupdate-4': return '!!!!!               WELCHE DADURCH ENTSTEHEN KÖNNEN              !!!!!';
        case 'loader-cli/warning-noupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-cli/warning-update-mod-not-supported': return `[Aktualisierung] WARNUNG: "${tokens.name}" unterstützt keine automatische Aktualisierung!`;
        case 'loader-cli/error-update-mod-failed': return `[Aktualisierung] FEHLER: "${tokens.name}" konnte nicht aktualisiert werden und ist möglicherweise beschädigt!`;
        case 'loader-cli/error-update-failed': return 'FEHLER: Automatische Aktualisierung nicht möglich! Die vollständige Fehlermeldung lautet:';

        // loader-gui
        case 'loader-gui/tray/quit': return 'Beenden';
        case 'loader-gui/error-config-file-corrupt/title': return 'Ungültige Einstellungsdatei!';
        case 'loader-gui/error-config-file-corrupt/message': return `Die Datei config.json im TERA Toolbox Ordner ist beschädigt. Versuche den Fehler selbst zu beheben, lösche sie um eine neue zu generieren, oder bitte hier ${tokens.supportUrl} um Hilfe!\n\nDas Programm wird jetzt beendet.`;
        case 'loader-gui/error-migration-failed/title': return 'Migrationsfehler!';
        case 'loader-gui/error-migration-failed/message': return `Dateien einer veralteten Version von TERA Toolbox konnten nicht migriert werden!\nInstalliere eine saubere Kopie mit dem neuesten Installationsprogramm oder bitte hier ${tokens.supportUrl} um Hilfe!\n\nDas Programm wird jetzt beendet.`;
        case 'loader-gui/error-cannot-start-proxy': return '[Toolbox] Der Netzwerk-Proxy kann nicht gestartet werden!';
        case 'loader-gui/terminating': return 'Programm wird beendet...';
        case 'loader-gui/warning-noselfupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noselfupdate-2': return '!!!!!  DU HAST AUTOMATISCHE TOOLBOX-AKTUALISIERUNGEN DEAKTIVIERT !!!!!';
        case 'loader-gui/warning-noselfupdate-3': return '!!!!!          ES GIBT KEINE UNTERSTÜTZUNG FÜR PROBLEME          !!!!!';
        case 'loader-gui/warning-noselfupdate-4': return '!!!!!               WELCHE DADURCH ENTSTEHEN KÖNNEN              !!!!!';
        case 'loader-gui/warning-noselfupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noupdate-2': return '!!!!!  DU HAST AUTOMATISCHE MODUL-AKTUALISIERUNGEN DEAKTIVIERT   !!!!!';
        case 'loader-gui/warning-noupdate-3': return '!!!!!          ES GIBT KEINE UNTERSTÜTZUNG FÜR PROBLEME          !!!!!';
        case 'loader-gui/warning-noupdate-4': return '!!!!!               WELCHE DADURCH ENTSTEHEN KÖNNEN              !!!!!';
        case 'loader-gui/warning-noupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-update-mod-not-supported': return `[Aktualisierung] WARNUNG: "${tokens.name}" unterstützt keine automatische Aktualisierung!`;
        case 'loader-gui/error-update-mod-failed': return `[Aktualisierung] FEHLER: "${tokens.name}" konnte nicht aktualisiert werden und ist möglicherweise beschädigt!`;
        case 'loader-gui/error-update-failed': return 'FEHLER: Automatische Aktualisierung nicht möglich! Die vollständige Fehlermeldung lautet:';
        case 'loader-gui/proxy-starting': return '[Toolbox] Netzwerk-Proxy wird gestartet...';
        case 'loader-gui/proxy-stopping': return '[Toolbox] Netzwerk-Proxy wird gestoppt...';
        case 'loader-gui/proxy-stopped': return '[Toolbox] Netzwerk-Proxy wurde gestoppt!';
        case 'loader-gui/mod-installed': return `[Toolbox] "${tokens.name}" wird installiert`;
        case 'loader-gui/mod-uninstalled': return `[Toolbox] "${tokens.name}" wird deinstalliert`;
        case 'loader-gui/mod-load-toggled': return `[Toolbox] "${tokens.name}" wurde ${tokens.enabled ? 'aktiviert' : 'deaktiviert'}`;
        case 'loader-gui/mod-updates-toggled': return `[Toolbox] Automatische Aktualisierung von "${tokens.name}" wurde ${tokens.updatesEnabled ? 'aktiviert' : 'deaktiviert'}`;

        // proxy
        case 'proxy/ready': return '[Toolbox] Bereit, warten auf den Start des Spiel-Clients!';
        case 'proxy/client-interface-error': return '[Toolbox] FEHLER: Client-Schnittstellen-Server kann nicht gestartet werden.';
        case 'proxy/client-interface-error-EADDRINUSE': return '[Toolbox] FEHLER: Eine andere Instanz von TERA Toolbox wird bereits ausgeführt. Bitte schließe sie oder starte deinen Computer neu und versuche es erneut!';
        case 'proxy/client-interface-error-EADDRNOTAVAIL': return '[Toolbox] FEHLER: Adresse nicht verfügbar. Starte deinen Computer neu und versuche es erneut!';
        case 'proxy/client-interface-connection-error': return `[Toolbox] Verbindung zum Client kann nicht hergestellt werden: ${tokens.error}`;
        case 'proxy/client-interface-connected': return `[Toolbox] Verbindung zum Client wurde ${tokens.justStarted ? 'hergestellt' : 'wieder hergestellt'} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion})`;
        case 'proxy/client-interface-disconnected': return `[Toolbox] Verbindung zum Client wurde beendet`;
        case 'proxy/redirecting-server': return `[Toolbox] Umleitung ${tokens.name} (${tokens.publisher.toUpperCase()}-${tokens.serverId}) von ${tokens.listen_ip}:${tokens.listen_port} zu ${tokens.ip}:${tokens.port}`;
        case 'proxy/warning-unmapped-protocol-1': return `[Toolbox] WARNUNG: Nicht zugeordnete Protokoll-Version ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion}) gefunden.`;
        case 'proxy/warning-unmapped-protocol-2': return '[Toolbox] WARNUNG: Dies kann eine der folgenden Ursachen haben:';
        case 'proxy/warning-unmapped-protocol-3': return '[Toolbox] WARNUNG: 1) Du versuchst, mit einer neu veröffentlichten Client-Version zu spielen, die noch nicht unterstützt wird.';
        case 'proxy/warning-unmapped-protocol-4': return '[Toolbox] WARNUNG:    Wenn in den letzten Stunden eine Wartung des Spiels stattgefunden hat, melde dies bitte!';
        case 'proxy/warning-unmapped-protocol-5': return '[Toolbox] WARNUNG:    Andernfalls wurde dein Client möglicherweise zu früh für einen bevorstehenden Patch aktualisiert.';
        case 'proxy/warning-unmapped-protocol-6': return '[Toolbox] WARNUNG: 2) Du versuchst, mit einer veralteten Client-Version zu spielen.';
        case 'proxy/warning-unmapped-protocol-7': return '[Toolbox] WARNUNG:    Versuche den Client zu reparieren oder das Spiel von Grund auf neu zu installieren, um dies zu beheben!';
        case 'proxy/warning-unmapped-protocol-8': return `[Toolbox] WARNUNG: Wenn du es nicht selbst beheben kannst, bitte hier um Hilfe: ${tokens.supportUrl}!`;
        case 'proxy/error-cannot-load-protocol': return `FEHLER: Protokoll-Version ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion}) konnte nicht geladen werden!`;
        case 'proxy/protocol-loaded': return `[Toolbox] Protokoll-Version ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion}) wurde erfolgreich geladen.`;
        case 'proxy/error-installing-gpks': return 'FEHLER: Client-Module können nicht installiert werden! Die komplette Fehlermeldung lautet:';

        // update
        case 'update/started': return '[Aktualisierung] Automatische Modul-Aktualisierung gestartet!';
        case 'update/core-module-initialized': return `[Aktualisierung] Kern-Modul "${tokens.coreModule}" wird heruntergeladen`;
        case 'update/dependency-module-initialized': return `[Aktualisierung] Sub-Modul "${tokens.dependency}" für "${tokens.name}" wird heruntergeladen`;
        case 'update/warning-module-update-disabled': return `[Aktualisierung] WARNUNG: Automatische Aktualisierung von "${tokens.name}" ist deaktiviert!`;
        case 'update/start-module-install': return `[Aktualisierung] "${tokens.name}" wird installiert`;
        case 'update/start-module-update': return `[Aktualisierung] "${tokens.name}" wird aktualisiert`;
        case 'update/warning-module-no-update-servers': return `[Aktualisierung] WARNUNG: "${tokens.name}" hat keinen Aktualisierungs-Server angegeben!`;
        case 'update/module-download-manifest': return `[Aktualisierung] Aktualisierungs-Manifest wird abgerufen (Server ${tokens.serverIndex})`;
        case 'update/module-download-file': return `[Aktualisierung] ${tokens.file} wird heruntergeladen`;
        case 'update/module-config-changed': return '[Aktualisierung] Modul-Konfiguration geändert, Aktualisierung wird neu gestartet!';
        case 'update/module-update-failed-1': return `[Aktualisierung] FEHLER: "${tokens.name}" kann nicht automatisch aktualisiert werden:`;
        case 'update/module-update-failed-2-1': return `[Aktualisierung] Gehe zu ${tokens.supportUrl} und befolge die angegebenen Anweisungen oder bitte um Hilfe.`;
        case 'update/module-update-failed-2-2': return `[Aktualisierung] Alternativ kannst du hier um Hilfe bitten: ${tokens.supportUrl}`;
        case 'update/module-update-failed-3': return `[Aktualisierung] Kontaktiere den Autor des Moduls oder bitte hier um Hilfe: ${tokens.supportUrl}`;
        case 'update/finished': return '[Aktualisierung] Automatische Modul-Aktualisierung abgeschlossen!';

        // gui
        case 'gui/tooltip/download': return 'Modul herunterladen';
        case 'gui/tooltip/remove': return 'Modul entfernen';
        case 'gui/tooltip/toggleMod': return 'Modul aktivieren / deaktivieren';
        case 'gui/tooltip/toggleModAutoupdate': return 'Modul-Aktualisierung aktivieren / deaktivieren';
        case 'gui/tooltip/donate': return 'Dem Autor spenden';
        case 'gui/tooltip/supportLink': return 'Modul-Unterstützungsseite besuchen';
        case 'gui/tooltip/readme': return 'Modul-Informationen abrufen';

        case 'gui/main/title': return 'TERA Toolbox';

        case 'gui/main/start-stop-proxy-running': return 'Stoppen';
        case 'gui/main/start-stop-proxy-not-running': return 'Starten';
        case 'gui/main/start-stop-proxy-starting': return 'Starten...';
        case 'gui/main/start-stop-proxy-stopping': return 'Stoppen...';

        case 'gui/main/status-proxy-running': return 'Status: Gestartet';
        case 'gui/main/status-proxy-not-running': return 'Status: Gestoppt';
        case 'gui/main/status-update-available': return 'AKTUALISIERUNG VERFÜGBAR - BITTE NEU STARTEN';

        case 'gui/main/modal/buttons/ok': return 'OK';
        case 'gui/main/modal/warn-mod-update-disabled': return 'WARNUNG! Du hast die automatische Aktualisierung für alle deine Module deaktiviert. Dies wird zur Folge haben das sie irgendwann nicht mehr funktionieren. Wir leisten keinerlei Unterstützung, außer sie sind wieder aktiviert!';
        case 'gui/main/modal/warn-self-update-disabled': return 'WARNUNG! Du hast die automatische Aktualisierung für alle deine Module deaktiviert. Dies wird zur Folge haben das sie irgendwann nicht mehr funktionieren. Wir leisten keinerlei Unterstützung, außer sie sind wieder aktiviert!';
        case 'gui/main/modal/error-cannot-install-mod-while-running': return 'Du kannst keine Module installieren, während TERA Toolbox ausgeführt wird. Bitte zuerst stoppen!';
        case 'gui/main/modal/error-cannot-uninstall-mod-while-running': return 'Du kannst keine Module deinstallieren, während TERA Toolbox ausgeführt wird. Bitte zuerst stoppen!';

        case 'gui/main/static/tabs/log/title': return 'Protokoll';
        case 'gui/main/static/tabs/log/loading': return 'Protokoll wird geladen ...';

        case 'gui/main/static/tabs/mods/title': return 'Meine Module';
        case 'gui/main/static/tabs/mods/loading': return 'Installierte Module werden geladen ...';

        case 'gui/main/static/tabs/newmods/title': return 'Mehr Module';
        case 'gui/main/static/tabs/newmods/loading': return 'Modul-Liste wird geladen ...';
        case 'gui/main/static/tabs/newmods/content/filter': return 'Filter: ';
        case 'gui/main/static/tabs/newmods/content/filter/network': return 'Netzwerk / Proxy-Module';
        case 'gui/main/static/tabs/newmods/content/filter/client': return 'Client / Benutzeroberflächen-Module';

        case 'gui/main/static/tabs/settings/title': return 'Einstellungen';
        case 'gui/main/static/tabs/settings/groupclient': return 'Game client:';
        case 'gui/main/static/tabs/settings/toolbox': return 'Tera Toolbox:';
        case 'gui/main/static/tabs/settings/loading': return 'Einstellungen werden geladen...';
        case 'gui/main/static/tabs/settings/content/uilanguage': return 'Sprache';
        case 'gui/main/static/tabs/settings/content/theme': return 'Thema';
        case 'gui/main/static/tabs/settings/content/autostart': return 'Automatischer Start nach dem Öffnen';
        case 'gui/main/static/tabs/settings/content/updatelog': return 'Detailliertes Aktualisierungs-Protokoll anzeigen';
        case 'gui/main/static/tabs/settings/content/logtimes': return 'Zeitstempel im Protokoll anzeigen';
        case 'gui/main/static/tabs/settings/content/noupdate': return 'Modul-Aktualisierungen deaktivieren';
        case 'gui/main/static/tabs/settings/content/noselfupdate': return 'Toolbox-Aktualisierungen deaktivieren';
        case 'gui/main/static/tabs/settings/content/devmode': return 'Entwicklermodus aktivieren';
        case 'gui/main/static/tabs/settings/content/noslstags': return 'Tags in der Serverliste ausblenden';
        case 'gui/main/static/tabs/settings/content/noserverautojoin': return 'Automatischen Server-Beitritt deaktivieren';
        case 'gui/main/static/tabs/settings/content/minimizetotray': return 'In ausgeblendete Symbole minimieren';
        case 'gui/main/static/tabs/settings/content/removecounters': return 'Charakter-Anzahl in der Serverliste verbergen';
        case 'gui/main/static/tabs/settings/content/cleanstart': return 'Neues Protokoll bei jedem Start';

        case 'gui/main/static/tabs/help/title': return 'Brauchst Du Hilfe?';

        case 'gui/main/static/tabs/modsfolder/title': return 'Modul-Ordner Öffnen';

        case 'gui/main/static/tabs/credits/title': return 'Mitwirkende';
        case 'gui/main/static/tabs/credits/loading': return 'Mitwirkende werden geladen...';
        case 'gui/main/static/tabs/credits/content': return 'Thanks to<br />SaltyMonkey: Installer/Modern UI stuff<br />Mathicha &amp; Pentagon: Old GUI stuff<br />Foglio: Logo design<br />Meishu: Original Tera-Proxy Core<br />All Toolbox Translators<br />All Mod Developers';

        // tera-client-interface
        case 'tera-client-interface/index/communication-error': return '[Toolbox] Fehler bei der Kommunikation mit dem Client:';

        case 'tera-client-interface/gpkmanager/symlink-warning-1': return '[Toolbox] WARNUNG: Es sieht so aus, als ob sich entweder TERA Toolbox oder das Spiel auf einem Laufwerk / einer Partition befinden,';
        case 'tera-client-interface/gpkmanager/symlink-warning-2': return '[Toolbox] WARNUNG: die keine symbolischen Links unterstützen (z. B. weil es mit exFAT oder FAT32 formatiert ist)!';
        case 'tera-client-interface/gpkmanager/symlink-warning-3': return '[Toolbox] WARNUNG: Als Fallback werden deine Client-Module installiert, indem stattdessen Dateikopien erstellt werden.';
        case 'tera-client-interface/gpkmanager/symlink-warning-4': return '[Toolbox] WARNUNG: Beachte, dass dies die Startzeit vom Client verlangsamen und deine Festplatte belasten kann!';
        case 'tera-client-interface/gpkmanager/uninstall-error-1': return '[Toolbox] WARNUNG: Die folgende Client-Modul-Datei kann nicht entfernt werden:';
        case 'tera-client-interface/gpkmanager/uninstall-error-2': return `[Toolbox] WARNUNG: ${tokens.fullPath}`;
        case 'tera-client-interface/gpkmanager/uninstall-error-3': return '[Toolbox] WARNUNG: Sie wird stattdessen gelöscht, wenn du das Spiel das nächste Mal startest. Du kannst sie auch manuell löschen.';

        // mod
        case 'mod/prefix-log': return `[${tokens.name}]`;
        case 'mod/prefix-warn': return `[${tokens.name}] WARNUNG:`;
        case 'mod/prefix-error': return `[${tokens.name}] FEHLER:`;
        case 'mod/settings-load-error-corrupted-1': return 'Du hast das Programm bei der letzten Verwendung nicht ordnungsgemäß geschlossen!';
        case 'mod/settings-load-error-corrupted-2': return `Dadurch wurden die Einstellungen von "${tokens.name}" beschädigt!`;
        case 'mod/settings-load-error-corrupted-3': return 'Das Modul lädt jetzt die Standard-Einstellungen, passe sie nach belieben an.';
        case 'mod/settings-load-error-corrupted-4': return 'Bitte denke daran, das Programm ordnungsgemäß zu schließen: Schließe zuerst das Spiel und dann TERA Toolbox mit dem X-Knopf!';
        case 'mod/settings-load-error-corrupted-5': return 'Fahre deinen Computer nicht herunter, während TERA Toolbox ausgeführt wird!';
        case 'mod/settings-load-error-invalid-format-1': return `Ungültiges Einstellungsformat von "${tokens.name}"!`;
        case 'mod/settings-load-error-invalid-format-2': return 'Dies bedeutet, dass du es beim manuellen Bearbeiten beschädigt hast.';
        case 'mod/settings-load-error-invalid-format-3': return 'Bitte korrigiere die Einstellungsdatei manuell oder lösche sie, damit die Standard-Einstellungen wiederhergestellt werden können.';
        case 'mod/settings-load-error-invalid-format-4': return '------------------------------------------';
        case 'mod/settings-load-error-invalid-format-5': return 'Erweiterte Fehlerdetails';
        case 'mod/settings-load-error-invalid-format-6': return 'Der vollständige Pfad zur Datei lautet:';
        case 'mod/settings-load-error-invalid-format-7': return `  ${tokens.settingsFile}`;
        case 'mod/settings-load-error-invalid-format-8': return 'Die vollständige Fehlermeldung lautet:';
        case 'mod/settings-load-error-invalid-format-9': return `  ${tokens.e}`;
        case 'mod/settings-load-error-invalid-format-10': return '------------------------------------------';
        case 'mod/settings-save-error-write': return 'Einstellungen können nicht gespeichert werden! Die vollständige Fehlermeldung lautet:';
        case 'mod/settings-save-error-stringify': return 'Einstellungen können nicht serialisiert werden! Die vollständige Fehlermeldung lautet:';
        case 'mod/settings-migrate-error-load-migrator': return 'Einstellungs-Migrator kann nicht geladen werden! Die vollständige Fehlermeldung lautet:';
        case 'mod/settings-migrate-error-run-migrator': return 'Bei der Migration der Einstellungen ist ein Fehler aufgetreten! Die vollständige Fehlermeldung lautet:';
        case 'mod/tera-game-state-not-loaded': return 'Dieses Modul könnte eine Fehlfunktion haben, weil "tera-game-state" nicht geladen werden konnte.';
        case 'mod/client-install-error-1': return `Ein Fehler ist während der Client-Modul-Installation aufgetreten!`;
        case 'mod/client-install-error-2': return `Bitte kontaktiere den Autor des Moduls: ${tokens.supportUrl}`;

        case 'mod/mod-preloaded': return `[Modul] ${tokens.name} wurde vorgeladen`;
        case 'mod/mod-preload-error-1': return `[Modul] FEHLER: ${tokens.name} konnte nicht vorgeladen werden!`;
        case 'mod/mod-preload-error-2': return `[Modul] FEHLER: Bitte kontaktiere den Autor des Moduls: ${tokens.supportUrl}`;
        case 'mod/mod-unloaded': return `[Modul] ${tokens.name} wurde entladen`;
        case 'mod/mod-reloaded': return `[Modul] ${tokens.name} wurde neu geladen`;

        case 'mod/mod-global-instance-loaded': return `[Modul] ${tokens.name} wurde geladen`;
        case 'mod/mod-global-instance-load-error-1': return `[Modul] FEHLER: ${tokens.name} konnte nicht geladen werden!`;
        case 'mod/mod-global-instance-load-error-2': return `[Modul] FEHLER: Bitte kontaktiere den Autor des Moduls: ${tokens.supportUrl}`;
        case 'mod/mod-global-instance-unloaded': return `[Modul] ${tokens.name} wurde entladen`;
        case 'mod/mod-global-instance-unload-error-1': return `[Modul] FEHLER: ${tokens.name} konnte nicht entladen werden!`;
        case 'mod/mod-global-instance-unload-error-2': return `[Modul] FEHLER: Bitte kontaktiere den Autor des Moduls: ${tokens.supportUrl}`;

        case 'mod/mod-client-instance-loaded': return `[Modul] Client-Komponente von ${tokens.name} wurde geladen`;
        case 'mod/mod-client-instance-load-error-1': return `[Modul] FEHLER: Client-Komponente von ${tokens.name} konnte nicht geladen werden!`;
        case 'mod/mod-client-instance-load-error-2': return `[Modul] FEHLER: Bitte kontaktiere den Autor des Moduls: ${tokens.supportUrl}`;
        case 'mod/mod-client-instance-unloaded': return `[Modul] Client-Komponente von ${tokens.name} wurde entladen`;
        case 'mod/mod-client-instance-unload-error-1': return `[Modul] FEHLER: Client-Komponente von ${tokens.name} konnte nicht entladen werden!`;
        case 'mod/mod-client-instance-unload-error-2': return `[Modul] FEHLER: Bitte kontaktiere den Autor des Moduls: ${tokens.supportUrl}`;

        case 'mod/mod-network-instance-loaded': return `[Modul] Netzwerk-Komponente von ${tokens.name} wurde geladen`;
        case 'mod/mod-network-instance-load-error-1': return `[Modul] FEHLER: Netzwerk-Komponente von ${tokens.name} konnte nicht geladen werden!`;
        case 'mod/mod-network-instance-load-error-2': return `[Modul] FEHLER: Bitte kontaktiere den Autor des Moduls: ${tokens.supportUrl}`;
        case 'mod/mod-network-instance-unloaded': return `[Modul] Netzwerk-Komponente von ${tokens.name} wurde entladen`;
        case 'mod/mod-network-instance-unload-error-1': return `[Modul] FEHLER: Netzwerk-Komponente von ${tokens.name} konnte nicht entladen werden!`;
        case 'mod/mod-network-instance-unload-error-2': return `[Modul] FEHLER: Bitte kontaktiere den Autor des Moduls: ${tokens.supportUrl}`;

        // mod-manager
        case 'mod-manager/load-module-info-error': return `[Modul] FEHLER: Modul-Informationen von "${tokens.name}" können nicht geladen werden! Die vollständige Fehlermeldung lautet:`;
        case 'mod-manager/duplicate-mod-error': return `[Modul] FEHLER: Modul-Duplikat von "${tokens.name}" gefunden!`;
        case 'mod-manager/missing-mod-dependency-error': return `[Modul] FEHLER: ${tokens.name} benötigt das Sub-Modul "${tokens.dependency}" welches nicht installiert ist!`;
        case 'mod-manager/mod-conflict-error': return `[Modul] FEHLER: ${tokens.name} kann nicht geladen werden, während "${tokens.conflict}" installiert ist!`;
        case 'mod-manager/cannot-load-mod-not-installed': return `[Modul] FEHLER: Versuch, ein nicht installiertes Modul zu laden: "${tokens.name}"`;
        case 'mod-manager/cannot-unload-mod-not-installed': return `[Modul] FEHLER: Versuch, ein nicht installiertes Modul zu entladen: "${tokens.name}"`;
        case 'mod-manager/cannot-unload-mod-not-loaded': return `[Modul] FEHLER: Versuch, ein nicht geladenes Modul zu entladen: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-installed': return `[Modul] FEHLER: Versuch, ein nicht installiertes Modul neu zu laden: "${tokens.name}"`;
        case 'mod-manager/cannot-reload-mod-not-supported': return `[Modul] FEHLER: Versuch, ein Modul neu zu laden, das kein Hot-Reload unterstützt: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-loaded': return `[Modul] FEHLER: Versuch, ein nicht geladenes Modul neu zu laden: ${tokens.name}`;

        // default
        default: throw new Error(`Invalid string "${str}"!`);
    }
};

module.exports = { Name, GetString };