const Name = 'Bosanski';

function GetString(str, tokens) {
    switch (str) {
        // connection-manager
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-1': return `[connection] GREŠKA: Nemoguće uspostaviti vezu sa serverom ${tokens.address}:${tokens.port} (${tokens.code})! Česti razlozi za ovo su:`;
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-2': return '[connection] - Nestabilna konekcija sa serverom ili geo-IP ban';
        case 'connection-manager/error-ECONNREFUSED-ETIMEDOUT-3': return '[connection] - Server održavanje';
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-1': return `[connection] GREŠKA: ${tokens.code} - Veza sa serverom je zatvorena. Čisti razlozi za ovo su:`;
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-2': return '[connection] - Prekinuta veza sa serverom jer internet nije stabilan';
        case 'connection-manager/error-ECONNABORTED-ECONNRESET-EPIPE-3': return '[connection] - Iskorištavanje/cheat ili pokvaren module te izbacuje';
        case 'connection-manager/connected': return `[connection] routing ${tokens.remote} to ${tokens.remoteAddress}:${tokens.remotePort}`;
        case 'connection-manager/disconnected': return `[connection] ${tokens.remote} disconnected`;

        // loader-cli
        case 'loader-cli/error-node-too-old-1': return 'GREŠKA: Tvoja verzina Nodule.JS je prestara za pokretanje TERA Toolbox!';
        case 'loader-cli/error-node-too-old-2': return 'GREŠKA: Molimo preuzmite i instalirajte ponovo TERA Toolbox, ili instaliraj noviju verziju Node.JS iz https://nodejs.org/en/download/current/';
        case 'loader-cli/error-runtime-incompatible-default': return `GREŠKA: ${tokens.message}`;
        case 'loader-cli/error-config-corrupt-1': return 'GREŠKA: Ops, čini se da ti je oštećen config.json';
        case 'loader-cli/error-config-corrupt-2': return `GREŠKA: Pokušaj popraviti sam, ili kontaktiraj ovdje: ${tokens.supportUrl}`;
        case 'loader-cli/error-migration-failed-1': return 'GREŠKA: Nemoguće migrirati fajlove sa stare verzije TERA Toolbox!';
        case 'loader-cli/error-migration-failed-2': return 'GREŠKA: Molimo instalirajte najnoviju verziju TERA Toolbox!';
        case 'loader-cli/error-migration-failed-3': return `GREŠKA: ili pitaj ovdje: ${tokens.supportUrl}`;
        case 'loader-cli/error-cannot-start-proxy': return '[toolbox] Nemogu uspostaviti vezu sa proxy, isključivanje...';
        case 'loader-cli/terminating': return 'isključivanje...';
        case 'loader-cli/warning-noupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-cli/warning-noupdate-2': return '!!!!!     AUTOMATSKO AŽURIRANJE VAM JE ISKLJUČENO!          !!!!!';
        case 'loader-cli/warning-noupdate-3': return '!!!!! PODRŠKE NEĆE BITI ZA BILO KOJI PROBLEM KOJI URADITE   !!!!!';
        case 'loader-cli/warning-noupdate-4': return '!!!!!      ZA BILO KAKAV REZULTAT KOJI DOBIJETE!            !!!!!';
        case 'loader-cli/warning-noupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-cli/warning-update-mod-not-supported': return `[update] UPOZORENJE: Module ${tokens.name} ne podržava automatsko ažuriranje.`;
        case 'loader-cli/error-update-mod-failed': return `[update] GREŠKA: Module ${tokens.name} nije moguće ažurirati ili je pokvaren!`;
        case 'loader-cli/error-update-failed': return 'GREŠKA: Nije moguće automatsko ažuriranje! Greška je:';

        // loader-gui
        case 'loader-gui/tray/quit': return 'Quit';
        case 'loader-gui/error-config-file-corrupt/title': return 'Nevažeće postavke!';
        case 'loader-gui/error-config-file-corrupt/message': return `config.json fajl u tvoj TERA Toolbox folder je nepravilan. Pokušaj popraviti sam, obriši da napravi se novi, ili pitaj ovdje ${tokens.supportUrl} za pomoć!\n\nProgram će se sad isključiti.`;
        case 'loader-gui/error-migration-failed/title': return 'Migracijska greška!';
        case 'loader-gui/error-migration-failed/message': return `Nemoguće migrirati fajlove sa stare verzije TERA Toolbox.\nMolimo instalirati sviježu kopiju ili pitati na ${tokens.supportUrl} for help!\n\nProgram će se sad isključiti.`;
        case 'loader-gui/error-cannot-start-proxy': return '[toolbox] Nemoguće uspostaviti vezu sa proxy!';
        case 'loader-gui/terminating': return 'terminating...';
        case 'loader-gui/warning-noselfupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noselfupdate-2': return '!!!!!    ISKLJUČIO SI AUTOMATSKO AŽURIRANJE ZA SELF-UPDATE  !!!!!';
        case 'loader-gui/warning-noselfupdate-3': return '!!!!! PODRŠKE NEĆE BITI ZA BILO KOJI PROBLEM KOJI URADITE   !!!!!';
        case 'loader-gui/warning-noselfupdate-4': return '!!!!!      ZA BILO KAKAV REZULTAT KOJI DOBIJETE!            !!!!!';
        case 'loader-gui/warning-noselfupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noupdate-1': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-noupdate-2': return '!!!!!     AUTOMATSKO AŽURIRANJE VAM JE ISKLJUČENO!          !!!!!';
        case 'loader-gui/warning-noupdate-3': return '!!!!! PODRŠKE NEĆE BITI ZA BILO KOJI PROBLEM KOJI URADITE   !!!!!';
        case 'loader-gui/warning-noupdate-4': return '!!!!!      ZA BILO KAKAV REZULTAT KOJI DOBIJETE!            !!!!!';
        case 'loader-gui/warning-noupdate-5': return '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!';
        case 'loader-gui/warning-update-mod-not-supported': return `[update] UPOZORENJE: Module ${tokens.name} ne podržava automatsko ažuriranje!`;
        case 'loader-gui/error-update-mod-failed': return `[update] GREŠKA: Module ${tokens.name} nije moguće ažurirati ili je pokvaren!`;
        case 'loader-gui/error-update-failed': return 'GREŠKA: Nije moguće ažurirati! Greška je:';
        case 'loader-gui/proxy-starting': return '[toolbox] Pokretanje proxy vezu...';
        case 'loader-gui/proxy-stopping': return '[toolbox] Prekidam proxy vezu...';
        case 'loader-gui/proxy-stopped': return '[toolbox] Proxy veza zaustavita!';
        case 'loader-gui/mod-installed': return `[toolbox] Instaliran "${tokens.name}"`;
        case 'loader-gui/mod-uninstalled': return `[toolbox] Uklonjen "${tokens.name}"`;
        case 'loader-gui/mod-load-toggled': return `[toolbox] ${tokens.enabled ? 'Uključen' : 'Isključen'} "${tokens.name}"`;
        case 'loader-gui/mod-updates-toggled': return `[toolbox] ${tokens.updatesEnabled ? 'Uključen' : 'Isključen'} automatsko ažuriranje za "${tokens.name}"`;

        // proxy
        case 'proxy/ready': return '[toolbox] Spremno, čekanje pokretanje igrice!';
        case 'proxy/client-interface-error': return '[toolbox] GREŠKA: Nemoguće pokretanje sučelje klijentskog servera.';
        case 'proxy/client-interface-error-EADDRINUSE': return '[toolbox] GREŠKA: Drugi program TERA Toolbox je već pokrenuta. Molimo isključite je ili resetirajte kompjuter!';
        case 'proxy/client-interface-error-EADDRNOTAVAIL': return '[toolbox] GREŠKA: IP adresa nije moguće. Molimo resetirajte kompjuter i pokušajte ponovo!';
        case 'proxy/client-interface-connection-error': return `[toolbox] Nije moguće uspostaviti konekciju sa korisnikom: ${tokens.error}`;
        case 'proxy/client-interface-connected': return `[toolbox] Korisnik ${tokens.justStarted ? 'connected' : 'reconnected'} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion})`;
        case 'proxy/client-interface-disconnected': return `[toolbox] Korisnik disconnected`;
        case 'proxy/redirecting-server': return `[toolbox] Preusmjeravanje ${tokens.name} (${tokens.publisher.toUpperCase()}-${tokens.serverId}) from ${tokens.listen_ip}:${tokens.listen_port} to ${tokens.ip}:${tokens.port}`;
        case 'proxy/warning-unmapped-protocol-1': return `[toolbox] UPOZORENJE: Unmapped protokol verzija ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion}).`;
        case 'proxy/warning-unmapped-protocol-2': return '[toolbox] UPOZORENJE: Ovo može urokovati zbog:';
        case 'proxy/warning-unmapped-protocol-3': return '[toolbox] UPOZORENJE: 1) Pokušavate igrati na novoj verziji koja još nije podržana!';
        case 'proxy/warning-unmapped-protocol-4': return '[toolbox] UPOZORENJE:    Ako je bilo održavanje servera prije nekoliko sati, molimo prijavite ovo!';
        case 'proxy/warning-unmapped-protocol-5': return '[toolbox] UPOZORENJE:    Inače, možda je tvoj klijent ažuriran na novoj verziji prerano.';
        case 'proxy/warning-unmapped-protocol-6': return '[toolbox] UPOZORENJE: 2) Pokušavate igrati na staroj verziji.';
        case 'proxy/warning-unmapped-protocol-7': return '[toolbox] UPOZORENJE:    Pokušajte popraviti sa klijentom, ili instalirajte od početka.';
        case 'proxy/warning-unmapped-protocol-8': return `[toolbox] UPOZORENJE: Ako ne možete popraviti sami, pitajte ovdje: ${tokens.supportUrl}!`;
        case 'proxy/error-cannot-load-protocol': return `GREŠKA: Nemoguće učitavanje protokola ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion})!`;
        case 'proxy/protocol-loaded': return `[toolbox] Učitan protokol verzija ${tokens.protocolVersion} (${tokens.publisher.toUpperCase()} v${tokens.majorPatchVersion}.${tokens.minorPatchVersion}).`;
        case 'proxy/error-installing-gpks': return 'UPOZORENJE: Nemoguće instalirati GPK modove! Puni uzorak greške je:';

        // update
        case 'update/started': return '[update] Automatsko ažuriranje pokrenut!';
        case 'update/core-module-initialized': return `[update] Initialized core module "${tokens.coreModule}"`;
        case 'update/dependency-module-initialized': return `[update] Initialized dependency "${tokens.dependency}" for module "${tokens.name}"`;
        case 'update/warning-module-update-disabled': return `[update] UPOZORENJE: Automatsko ažuriranje je isključen za ovaj module! ${tokens.name}!`;
        case 'update/start-module-install': return `[update] Instaliranje module ${tokens.name}`;
        case 'update/start-module-update': return `[update] Ažuriranje module ${tokens.name}`;
        case 'update/warning-module-no-update-servers': return `[update] UPOZORENJE: Module ${tokens.name} nema server za ažuriranje!`;
        case 'update/module-download-manifest': return `[update] - Retrieving update manifest (Server ${tokens.serverIndex})`;
        case 'update/module-download-file': return `[update] - Download ${tokens.file}`;
        case 'update/module-config-changed': return '[update] - Module konfiguracija promjenjena, restartiram ažuriranje!';
        case 'update/module-update-failed-1': return `[update] GREŠKA: Nemoguće automatsko ažuriranje. ${tokens.name}:`;
        case 'update/module-update-failed-2-1': return `[update] Molimo idite na ${tokens.supportUrl} i pratite instrukcije ili tražite pomoć.`;
        case 'update/module-update-failed-2-2': return `[update] Alternativno, pitaj ovdje: ${tokens.supportUrl}`;
        case 'update/module-update-failed-3': return `[update] Molimo kontaktirajte autora ili pitaj ovdje: ${tokens.supportUrl}`;
        case 'update/finished': return '[update] Automatsko ažuriranje gotovo!';

        // gui
        case 'gui/tooltip/download': return 'Skini mod';
        case 'gui/tooltip/remove': return 'Ukloni mod';
        case 'gui/tooltip/toggleMod': return 'Uključi/isključi mod';
        case 'gui/tooltip/toggleModAutoupdate': return 'Uključi/isključi mod autoupdate';
        case 'gui/tooltip/donate': return 'Doniraj autoru';
        case 'gui/tooltip/supportLink': return 'Posijetite stranicu autora';
        case 'gui/tooltip/readme': return 'Otvori fajl sa informacijom';

        case 'gui/main/title': return 'TERA Toolbox';
        
        case 'gui/main/start-stop-proxy-running': return 'Stop';
        case 'gui/main/start-stop-proxy-not-running': return 'Pokreni';
        case 'gui/main/start-stop-proxy-starting': return 'Pokrećem...';
        case 'gui/main/start-stop-proxy-stopping': return 'Zaustavljam...';

        case 'gui/main/status-proxy-running': return 'Pokrenuto';
        case 'gui/main/status-proxy-not-running': return 'Nije pokrenuto';
        case 'gui/main/status-update-available': return 'NOVA VERZIJA DOSTUPNA - MOLIMO RESETERIJATE';

        case 'gui/main/modal/buttons/ok': return 'OK';
        case 'gui/main/modal/warn-mod-update-disabled': return 'Upozorenje! Isključio si ažuriranje sa sve modove. Može pokvariti dosta stvari sa vremenom. Nećemo pružiti pomoć sve dok ne upalite automatsko ažuriranje!';
        case 'gui/main/modal/warn-self-update-disabled': return 'Upozorenje! Iključio si automatsko ažuriranje za TERA Toolbox. Može pokvariti dosta stvari sa vremenom. Nećemo pružiti pomoć sve dok ne upalite automatsko ažuriranje!';
        case 'gui/main/modal/error-cannot-install-mod-while-running': return 'Nemožes instalirati modove dok je toolbox pokrenut. Zaustavi prvo pa pokušaj ponovo!';
        case 'gui/main/modal/error-cannot-uninstall-mod-while-running': return 'Nemožes izbrisati modove dok je toolbox pokrenut. Zaustavi prvo pa pokušaj ponovo!';

        case 'gui/main/static/tabs/log/title': return 'Log';
        case 'gui/main/static/tabs/log/loading': return 'Učitavanje proxy log...';

        case 'gui/main/static/tabs/mods/title': return 'Moje modove';
        case 'gui/main/static/tabs/mods/loading': return 'Učitavanje modova...';

        case 'gui/main/static/tabs/newmods/title': return 'Skini modove';
        case 'gui/main/static/tabs/newmods/loading': return 'Učitavanje listu modova...';
        case 'gui/main/static/tabs/newmods/content/filter': return 'Traženje: ';
        case 'gui/main/static/tabs/newmods/content/filter/network': return 'Network / Proxy Mods';
        case 'gui/main/static/tabs/newmods/content/filter/client': return 'Client / UI Mods';

        case 'gui/main/static/tabs/settings/title': return 'Postavke';
        case 'gui/main/static/tabs/settings/groupclient': return 'Game client:';
        case 'gui/main/static/tabs/settings/toolbox': return 'Tera Toolbox:';
        case 'gui/main/static/tabs/settings/loading': return 'Učitavanje postavke...';
        case 'gui/main/static/tabs/settings/content/uilanguage': return 'Jezike';
        case 'gui/main/static/tabs/settings/content/theme': return 'Tema';
        case 'gui/main/static/tabs/settings/content/autostart': return 'Automatski pokreni toolbox';
        case 'gui/main/static/tabs/settings/content/updatelog': return 'Pokaži detaljne logove';
        case 'gui/main/static/tabs/settings/content/logtimes': return 'Pokaži vrijeme u logove';
        case 'gui/main/static/tabs/settings/content/noupdate': return 'Iskljuci module ažuriranje';
        case 'gui/main/static/tabs/settings/content/noselfupdate': return 'Isključi self-updates';
        case 'gui/main/static/tabs/settings/content/devmode': return 'Uključi Developer Mode';
        case 'gui/main/static/tabs/settings/content/noslstags': return 'Sakrij proxy u server listovima';
        case 'gui/main/static/tabs/settings/content/noserverautojoin': return 'Isključi automatsko ulaženje u server';
        case 'gui/main/static/tabs/settings/content/minimizetotray': return 'Spusti prozor u taskbar';
        case 'gui/main/static/tabs/settings/content/removecounters': return 'Sakrij countere na server listi';
        case 'gui/main/static/tabs/settings/content/cleanstart': return 'Očisti logove na svakom pokretanju Toolboxa';

        case 'gui/main/static/tabs/help/title': return 'Trebate pomoć?';

        case 'gui/main/static/tabs/modsfolder/title': return 'Pokaži modove u folderu';

        case 'gui/main/static/tabs/credits/title': return 'Zasluge';
        case 'gui/main/static/tabs/credits/loading': return 'Učitavanje zasluge...';
        case 'gui/main/static/tabs/credits/content': return 'Thanks to<br />SaltyMonkey: Installer/Modern UI stuff<br />Mathicha &amp; Pentagon: Old GUI stuff<br />Foglio: Logo design<br />Meishu: Original Tera-Proxy Core<br />All Toolbox Translators<br />All Mod Developers';

        // tera-client-interface
        case 'tera-client-interface/index/communication-error': return '[toolbox] Greška uspostavljenje konekcije sa klijentom:';

        case 'tera-client-interface/gpkmanager/symlink-warning-1': return '[toolbox] UPOZORENJE: Izgleda da se TERA Toolbox ili igra nalaze na pogonu / particiji koja čini';
        case 'tera-client-interface/gpkmanager/symlink-warning-2': return '[toolbox] UPOZORENJE: ne podržava simboličke veze (naprimjer jer je formatiran sa exFAT ili FAT32)!';
        case 'tera-client-interface/gpkmanager/symlink-warning-3': return '[toolbox] UPOZORENJE: Kao rezultat, vaši korisničke modove bit će instalirani kreiranjem datoteka.';
        case 'tera-client-interface/gpkmanager/symlink-warning-4': return '[toolbox] UPOZORENJE: Značenje da će startanje klijenta biti teže i štetno za vaš pogon/disk!';
        case 'tera-client-interface/gpkmanager/uninstall-error-1': return '[toolbox] UPOZORENJE: Nije moguće izbrisati sljedeći mod fajl';
        case 'tera-client-interface/gpkmanager/uninstall-error-2': return `[toolbox] UPOZORENJE: ${tokens.fullPath}`;
        case 'tera-client-interface/gpkmanager/uninstall-error-3': return '[toolbox] UPOZORENJE: Bit će izbrisan sljedeći put kad pokrenete igricu, ili možete ručno ukloniti.';

        // mod
        case 'mod/prefix-log': return `[${tokens.name}]`;
        case 'mod/prefix-warn': return `[${tokens.name}] UPOZORENJE:`;
        case 'mod/prefix-error': return `[${tokens.name}] GREŠKA:`;
        case 'mod/settings-load-error-corrupted-1': return 'Isključio si program naglo prošli put kad si koristio.';
        case 'mod/settings-load-error-corrupted-2': return `Ovo je urokovalo postavke "${tokens.name}" da se pokvari!`;
        case 'mod/settings-load-error-corrupted-3': return 'Module će učitati zadane postavke, napravi ih po svom ukusu.';
        case 'mod/settings-load-error-corrupted-4': return 'Molimo da zatvorite program po pravilu: prvo zatvorite igricu, pa onda Toolbox sa X dugme.';
        case 'mod/settings-load-error-corrupted-5': return 'Nemojte isključi kompjuter dok Tera Toolbox je pokrenut!';
        case 'mod/settings-load-error-invalid-format-1': return `Nepravilne postavke za module "${tokens.name}"!`;
        case 'mod/settings-load-error-invalid-format-2': return 'Što znači da ste pokvarili jer ste sami odradili postavke.';
        case 'mod/settings-load-error-invalid-format-3': return 'Molimo popravite ili uklonite da se napravi nove postavke.';
        case 'mod/settings-load-error-invalid-format-4': return '------------------------------------------';
        case 'mod/settings-load-error-invalid-format-5': return 'Detaljnije greške';
        case 'mod/settings-load-error-invalid-format-6': return 'The full path to the file is:';
        case 'mod/settings-load-error-invalid-format-7': return `  ${tokens.settingsFile}`;
        case 'mod/settings-load-error-invalid-format-8': return 'The full error message is:';
        case 'mod/settings-load-error-invalid-format-9': return `  ${tokens.e}`;
        case 'mod/settings-load-error-invalid-format-10': return '------------------------------------------';
        case 'mod/settings-save-error-write': return 'Nemoguće spremiti postavke! Puna greška:';
        case 'mod/settings-save-error-stringify': return 'Nije moguće searalizirati postavke! Puna greška:';
        case 'mod/settings-migrate-error-load-migrator': return 'Nije moguće učitati migrator postavke! Puna greška:';
        case 'mod/settings-migrate-error-run-migrator': return 'Nije moguće učitati migrator postavke! Puna greška:';
        case 'mod/tera-game-state-not-loaded': return 'Ovaj mod može se pokvariti, jer "tera-game-state" nije se mogao učitati.';
        case 'mod/client-install-error-1': return `Došlo je do greške prilikom instaliranja korisničkih komponenta!`;
        case 'mod/client-install-error-2': return `Molimo kontaktirajte autora moda: ${tokens.supportUrl}`;
        
        case 'mod/mod-preloaded': return `[mods] Predučitavanje module ${tokens.name}`;
        case 'mod/mod-preload-error-1': return `[mods] GREŠKA: Module ${tokens.name} nije mogao se predučitati!`;
        case 'mod/mod-preload-error-2': return `[mods] GREŠKA: Molimo kontaktiraj autora moda: ${tokens.supportUrl}`;
        case 'mod/mod-unloaded': return `[mods] Istovaranje modula ${tokens.name}`;
        case 'mod/mod-reloaded': return `[mods] Očitavanje module ${tokens.name}`;
        
        case 'mod/mod-global-instance-loaded': return `[mods] Pokrenut module ${tokens.name}`;
        case 'mod/mod-global-instance-load-error-1': return `[mods] GREŠKA: Module ${tokens.name} nije moguće pokrenuti!`;
        case 'mod/mod-global-instance-load-error-2': return `[mods] GREŠKA: Molimo kontaktiraj autora moda: ${tokens.supportUrl}`;
        case 'mod/mod-global-instance-unloaded': return `[mods] Zaustavit module ${tokens.name}`;
        case 'mod/mod-global-instance-unload-error-1': return `[mods] GREŠKA: Module ${tokens.name} nije moguće zaustaviti!`;
        case 'mod/mod-global-instance-unload-error-2': return `[mods] GREŠKA: Molimo kontaktiraj autora moda: ${tokens.supportUrl}`;
        
        case 'mod/mod-client-instance-loaded': return `[mods] Povezan module ${tokens.name} na korisnika`;
        case 'mod/mod-client-instance-load-error-1': return `[mods] GREŠKA: Module ${tokens.name} nemože se povezati!`;
        case 'mod/mod-client-instance-load-error-2': return `[mods] GREŠKA: Molimo kontaktiraj autora moda: ${tokens.supportUrl}`;
        case 'mod/mod-client-instance-unloaded': return `[mods] Prekinut module ${tokens.name} od korisnika`;
        case 'mod/mod-client-instance-unload-error-1': return `[mods] GREŠKA: Module ${tokens.name} nije moguće prekinuti od korisnika!`;
        case 'mod/mod-client-instance-unload-error-2': return `[mods] GREŠKA: Molimo kontaktiraj autora moda: ${tokens.supportUrl}`;
        
        case 'mod/mod-network-instance-loaded': return `[mods] Postavljanje module ${tokens.name} na server konekciju`;
        case 'mod/mod-network-instance-load-error-1': return `[mods] GREŠKA: Module ${tokens.name} nije moguce uspotaviti vezu sa server konekcijom!`;
        case 'mod/mod-network-instance-load-error-2': return `[mods] GREŠKA: Molimo kontaktiraj autora moda: ${tokens.supportUrl}`;
        case 'mod/mod-network-instance-unloaded': return `[mods] Ukinut module ${tokens.name} sa server konekcije`;
        case 'mod/mod-network-instance-unload-error-1': return `[mods] GREŠKA: Module ${tokens.name} nije moguce ukloniti sa server konekcije!`;
        case 'mod/mod-network-instance-unload-error-2': return `[mods] GREŠKA: Molimo kontaktiraj autora moda: ${tokens.supportUrl}`;

        // mod-manager
        case 'mod-manager/load-module-info-error': return `[mods] GREŠKA: Nije moguće učitati module "${tokens.name}"! Puna greška:`;
        case 'mod-manager/duplicate-mod-error': return `[mods] GREŠKA: Dupli module "${tokens.name}" očitan!`;
        case 'mod-manager/missing-mod-dependency-error': return `[mods] GREŠKA: Module ${tokens.name} treba "${tokens.dependency}" da je instaliran, ali nije!`;
        case 'mod-manager/mod-conflict-error': return `[mods] GREŠKA: Module ${tokens.name} nemože se učitati dok "${tokens.conflict}" je instaliran!`;
        case 'mod-manager/cannot-load-mod-not-installed': return `[mods] GREŠKA: Pokušavam učitati module koji nije instaliran: ${tokens.name}`;
        case 'mod-manager/cannot-unload-mod-not-installed': return `[mods] GREŠKA: Pokušavam zaustaviti module koji nije instaliran: ${tokens.name}`;
        case 'mod-manager/cannot-unload-mod-not-loaded': return `[mods] GREŠKA: Pokušavam zaustaviti module koji nije instaliran: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-installed': return `[mods] GREŠKA: Pokušavam učitat ponovo module koji nije instaliran: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-supported': return `[mods] GREŠKA: Trying to reload module that does not support hot reloading: ${tokens.name}`;
        case 'mod-manager/cannot-reload-mod-not-loaded': return `[mods] GREŠKA: Pokušavam učitati module koji nije učitan?: ${tokens.name}`;

        // default
        default: throw new Error(`Invalid string "${str}"!`);
    }
};

module.exports = { Name, GetString };
