const path = require('path');
const fs = require('fs');

const LanguageFolder = path.join(__dirname, 'language');
const DefaultLanguage = 'en';

// Load valid languages
let LanguageNames = {};
fs.readdirSync(LanguageFolder).filter(filename => filename.endsWith('.js')).map(filename => filename.replace('.js', '')).forEach(language => {
    LanguageNames[language] = require(path.join(LanguageFolder, `${language}.js`)).Name;
});

// MUI implementation
class TeraToolboxMUI {
    constructor(language) {
        this.language = language;
        if (!this.language || !LanguageNames[this.language])
            this.language = DefaultLanguage;

        this.implementation = require(path.join(LanguageFolder, `${this.language}.js`)).GetString;
    }

    get(str, tokens) {
        return this.implementation(str, tokens);
    }
}

// Default instance
let DefaultInstance = null;
function InitializeDefaultInstance(language) {
    DefaultInstance = new TeraToolboxMUI(language);
    return DefaultInstance;
}

InitializeDefaultInstance(DefaultLanguage);

// Exports
module.exports = {
    DefaultLanguage, InitializeDefaultInstance, LanguageNames, TeraToolboxMUI,
    DefaultInstance: {
        get: function (...args) { return DefaultInstance.get(...args); },
        get language() { return DefaultInstance.language; }
    }
};
