const DefaultSettings = {
    silent_mode: false,
    login_message: true,
    private_channel_name: 'Toolbox',
    public_enable: true,
    hide_module_names: false,
}

module.exports = function MigrateSettings(from_ver, to_ver, settings) {
    if (from_ver === undefined) {
        // Migrate legacy config file
        return Object.assign(Object.assign({}, DefaultSettings), settings);
    } else if (from_ver === null) {
        // No config file exists, use default settings
        return DefaultSettings;
    } else {
        // Migrate from older version (using the new system) to latest one
        if (from_ver + 1 < to_ver) { // Recursively upgrade in one-version steps
            settings = MigrateSettings(from_ver, from_ver + 1, settings);
            return MigrateSettings(from_ver + 1, to_ver, settings);
        }

        // If we reach this point it's guaranteed that from_ver === to_ver - 1, so we can implement
        // a switch for each version step that upgrades to the next version. This enables us to
        // upgrade from any version to the latest version without additional effort!
        switch (to_ver) {
            case 2:
                if (settings.private_channel_name === 'Proxy')
                    settings.private_channel_name = 'Toolbox';
                break;
            case 3:
               settings.silent_mode = false;
               break;
        }

        return settings;
    }
}
